/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.modules.square.SectorChronoXAudio;
import jpsxdec.modules.square.SectorFF8;
import jpsxdec.modules.square.SectorFF9;
import jpsxdec.util.IOIterator;

public class SectorClaimToSquareAudioSector
implements SectorClaimSystem.SectorClaimer {
    @CheckForNull
    public static ISquareAudioSector id(@Nonnull CdSector sector) {
        IdentifiedSector id = new SectorFF8.SectorFF8Audio(sector);
        if (id.getProbability() > 0) {
            return id;
        }
        id = new SectorFF9.SectorFF9Audio(sector);
        if (id.getProbability() > 0) {
            return id;
        }
        id = new SectorChronoXAudio(sector);
        if (id.getProbability() > 0) {
            return id;
        }
        return null;
    }

    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws IOException, LoggedFailure {
        if (cs.isClaimed()) {
            return;
        }
        ISquareAudioSector audSector = SectorClaimToSquareAudioSector.id(cs.getSector());
        if (audSector == null) {
            return;
        }
        cs.claim(audSector);
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
    }
}

