/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.square.SectorFF7Video;
import jpsxdec.util.IOIterator;

public class SectorClaimToFF7Sector
implements SectorClaimSystem.SectorClaimer {
    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws IOException {
        if (cs.isClaimed()) {
            return;
        }
        SectorFF7Video firstFF7 = new SectorFF7Video(cs.getSector());
        if (firstFF7.getProbability() == 0 || firstFF7.getChunkNumber() != 0) {
            return;
        }
        ArrayList<SectorClaimSystem.ClaimableSector> claimSects = new ArrayList<SectorClaimSystem.ClaimableSector>();
        ArrayList<SectorFF7Video> ff7Sects = new ArrayList<SectorFF7Video>();
        claimSects.add(cs);
        ff7Sects.add(firstFF7);
        while (true) {
            SectorFF7Video nextFF7;
            if (!peekIt.hasNext()) {
                return;
            }
            SectorClaimSystem.ClaimableSector nextCs = peekIt.next();
            if (nextCs.isClaimed() || (nextFF7 = new SectorFF7Video(nextCs.getSector())).getProbability() == 0) continue;
            if (nextFF7.getSectorNumber() > firstFF7.getSectorNumber() + 20) {
                return;
            }
            if (nextFF7.getHeaderFrameNumber() != firstFF7.getHeaderFrameNumber() || nextFF7.getWidth() != firstFF7.getWidth() || nextFF7.getHeight() != firstFF7.getHeight() || nextFF7.getChunksInFrame() != firstFF7.getChunksInFrame()) {
                return;
            }
            if (nextFF7.getChunkNumber() != ff7Sects.size()) {
                return;
            }
            ff7Sects.add(nextFF7);
            claimSects.add(nextCs);
            if (nextFF7.getChunkNumber() + 1 == nextFF7.getChunksInFrame()) break;
        }
        for (int i = 0; i < claimSects.size(); ++i) {
            SectorClaimSystem.ClaimableSector ff7ClaimableSector = (SectorClaimSystem.ClaimableSector)claimSects.get(i);
            ff7ClaimableSector.claim((IIdentifiedSector)ff7Sects.get(i));
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
    }
}

