/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;

public class SectorChronoXVideoNull
extends IdentifiedSector {
    private long _lngMagic;
    private int _iChunkNumber;
    private int _iChunksInThisFrame;
    private int _iFrameNumber;

    public SectorChronoXVideoNull(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        if (this.subModeExistsAndMaskEquals(10, 0)) {
            return;
        }
        this._lngMagic = cdSector.readUInt32LE(0);
        if (this._lngMagic != 2164326752L && this._lngMagic != 16974176L) {
            return;
        }
        this._iChunkNumber = cdSector.readSInt16LE(4);
        if (this._iChunkNumber < 0) {
            return;
        }
        this._iChunksInThisFrame = cdSector.readSInt16LE(6);
        if (this._iChunksInThisFrame < 1) {
            return;
        }
        this._iFrameNumber = cdSector.readSInt16LE(8);
        if (this._iFrameNumber < 0) {
            return;
        }
        for (int i = 10; i < 32; ++i) {
            if (cdSector.readUserDataByte(i) == -1) continue;
            return;
        }
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "CX Video Null";
    }

    @Override
    public String toString() {
        return String.format("%s %s frame:%d chunk:%d/%d", this.getTypeName(), super.cdToString(), this._iFrameNumber, this._iChunkNumber, this._iChunksInThisFrame);
    }
}

