/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.modules.square.SquareAKAOstruct;
import jpsxdec.util.ByteArrayFPIS;

public class SectorChronoXAudio
extends IdentifiedSector
implements ISquareAudioSector {
    private static final Logger LOG = Logger.getLogger(SectorChronoXAudio.class.getName());
    public static final long AUDIO_CHUNK_MAGIC1 = 352L;
    public static final long AUDIO_CHUNK_MAGIC2 = 65888L;
    public static final long AUDIO_CHUNK_MAGIC3 = 0x1000160L;
    public static final long AUDIO_CHUNK_MAGIC4 = 0x1010160L;
    public static final int FRAME_AUDIO_CHUNK_HEADER_SIZE = 208;
    private int _iAudioChunkNumber;
    private int _iAudioChunksInFrame;
    private int _iHeaderFrameNumber;
    @CheckForNull
    private SquareAKAOstruct _akaoStruct;
    private int _iSoundUnitCount;

    public SectorChronoXAudio(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        if (this.subModeExistsAndMaskDoesNotEqual(40, 8)) {
            return;
        }
        long lngMagic = cdSector.readUInt32LE(0);
        if (lngMagic != 352L && lngMagic != 65888L && lngMagic != 0x1000160L && lngMagic != 0x1010160L) {
            return;
        }
        this._iAudioChunkNumber = cdSector.readSInt16LE(4);
        if (this._iAudioChunkNumber != 0 && this._iAudioChunkNumber != 1) {
            return;
        }
        this._iAudioChunksInFrame = cdSector.readSInt16LE(6);
        if (this._iAudioChunksInFrame != 2) {
            return;
        }
        this._iHeaderFrameNumber = cdSector.readSInt16LE(8);
        if (this._iHeaderFrameNumber < 1) {
            return;
        }
        this._akaoStruct = new SquareAKAOstruct(cdSector, 128);
        if (this._akaoStruct.AKAO != 1329679169L) {
            return;
        }
        if (this._akaoStruct.BytesOfData > 2324L) {
            return;
        }
        if (this._akaoStruct.BytesOfData % 16L != 0L) {
            LOG.log(Level.WARNING, "Bytes of audio data {0} is not a multiple of sound unit size in sector {1}", new Object[]{this._akaoStruct.BytesOfData, cdSector});
        }
        this._iSoundUnitCount = (int)(this._akaoStruct.BytesOfData / 16L);
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "CX Audio";
    }

    @Override
    public int getSoundUnitCount() {
        return this._iSoundUnitCount;
    }

    @Override
    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    @Override
    public int getSampleFramesPerSecond() {
        return 44100;
    }

    @Override
    public boolean isLeftChannel() {
        switch (this._iAudioChunkNumber) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getAudioDataStartOffset() {
        return 208;
    }

    @Override
    public int getAudioDataSize() {
        return (int)this._akaoStruct.BytesOfData;
    }

    @Override
    @Nonnull
    public ByteArrayFPIS getIdentifiedUserDataStream() {
        return new ByteArrayFPIS(this.getCdSector().getCdUserDataStream(), 208, this.getAudioDataSize());
    }

    @Override
    public String toString() {
        return String.format("%s %s frame:%d chunk:%d/%d %s", this.getTypeName(), super.toString(), this._iHeaderFrameNumber, this._iAudioChunkNumber, this._iAudioChunksInFrame, this._akaoStruct == null ? "<indexing>" : this._akaoStruct.toString());
    }
}

