/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.square.SectorFF9;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameBuilder;

public class FF9Demuxer
implements ISelfDemuxingVideoSector.IDemuxer {
    @Nonnull
    private final SectorBasedFrameBuilder<SectorFF9.SectorFF9Video> _bldr;
    private final int _iWidth;
    private final int _iHeight;

    public FF9Demuxer(@Nonnull SectorFF9.SectorFF9Video firstChunk, @Nonnull ILocalizedLogger log) {
        this._bldr = new SectorBasedFrameBuilder<SectorFF9.SectorFF9Video>(firstChunk, firstChunk.getInvertedVideoChunkNumber(), firstChunk.getVideoChunksInFrame(), firstChunk.getSectorNumber(), firstChunk.getHeaderFrameNumber(), log);
        this._iWidth = firstChunk.getWidth();
        this._iHeight = firstChunk.getHeight();
    }

    @Override
    public boolean addSectorIfPartOfFrame(@Nonnull ISelfDemuxingVideoSector sector) {
        if (!(sector instanceof SectorFF9.SectorFF9Video)) {
            return false;
        }
        return this.addFF9SectorIfPartOfFrame((SectorFF9.SectorFF9Video)sector);
    }

    public boolean addFF9SectorIfPartOfFrame(@Nonnull SectorFF9.SectorFF9Video chunk) {
        return chunk.getWidth() == this._iWidth && chunk.getHeight() == this._iHeight && this._bldr.addSectorIfPartOfFrame(chunk, chunk.getInvertedVideoChunkNumber(), chunk.getVideoChunksInFrame(), chunk.getSectorNumber(), chunk.getHeaderFrameNumber());
    }

    @Override
    public boolean isFrameComplete() {
        return this._bldr.isFrameComplete();
    }

    @Override
    @Nonnull
    public DemuxedFrameWithNumberAndDims finishFrame(@Nonnull ILocalizedLogger log) {
        ArrayList<SectorFF9.SectorFF9Video> sectors = this._bldr.getNonNullChunks(log);
        Collections.reverse(sectors);
        return new DemuxedFrameWithNumberAndDims(this._iWidth, this._iHeight, this._bldr.getHeaderFrameNumber(), sectors);
    }
}

