/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jpsxdec.adpcm.SpuAdpcmEncoder;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.square.SquareAudioSectorPair;
import jpsxdec.modules.square.SquareAudioSectorPairToAudioPacket;
import jpsxdec.modules.square.SquareAudioSectorToSquareAudioSectorPair;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;

public class DiscItemSquareAudioStream
extends DiscItemAudioStream {
    private static final Logger LOG = Logger.getLogger(DiscItemSquareAudioStream.class.getName());
    public static final String TYPE_ID = "SquareAudio";
    private static final String SOUND_UNIT_COUNT_KEY = "Sound unit count";
    private final int _iSoundUnitCount;
    private static final String SAMPLES_PER_SEC_KEY = "Samples/Sec";
    private final int _iSampleFramesPerSecond;
    private static final String SECTORS_PAST_END_KEY = "Sectors past end";
    private final int _iSectorsPastEnd;

    public DiscItemSquareAudioStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, int iSoundUnitCount, int iSampleFramesPerSecond, int iSectorsPastEnd) {
        super(cd, iStartSector, iEndSector);
        this._iSoundUnitCount = iSoundUnitCount;
        this._iSampleFramesPerSecond = iSampleFramesPerSecond;
        this._iSectorsPastEnd = iSectorsPastEnd;
    }

    public DiscItemSquareAudioStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._iSampleFramesPerSecond = fields.getInt(SAMPLES_PER_SEC_KEY);
        this._iSoundUnitCount = fields.getInt(SOUND_UNIT_COUNT_KEY);
        this._iSectorsPastEnd = fields.getInt(SECTORS_PAST_END_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem fields = super.serialize();
        fields.addNumber(SAMPLES_PER_SEC_KEY, this._iSampleFramesPerSecond);
        fields.addNumber(SOUND_UNIT_COUNT_KEY, this._iSoundUnitCount);
        fields.addNumber(SECTORS_PAST_END_KEY, this._iSectorsPastEnd);
        return fields;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean isStereo() {
        return true;
    }

    @Override
    public int getSectorsPastEnd() {
        return this._iSectorsPastEnd;
    }

    @Override
    public int getDiscSpeed() {
        return 2;
    }

    @Override
    public int getPresentationStartSector() {
        return this.getStartSector() + 1;
    }

    @Override
    public long getSampleFrameCount() {
        return (long)this._iSoundUnitCount * 28L;
    }

    @Override
    public double getApproxDuration() {
        return (double)this.getSampleFrameCount() / (double)this._iSampleFramesPerSecond;
    }

    @Override
    public int getSampleFramesPerSecond() {
        return this._iSampleFramesPerSecond;
    }

    @Override
    @Nonnull
    public ILocalizedMessage getInterestingDescription() {
        Date secs = Misc.dateFromSeconds((int)Math.max(this.getSampleFrameCount() / (long)this._iSampleFramesPerSecond, 1L));
        return I.GUI_AUDIO_DESCRIPTION(secs, this._iSampleFramesPerSecond, 2);
    }

    @Override
    @Nonnull
    public ISectorAudioDecoder makeDecoder(double dblVolume) {
        return new SquareConverter(dblVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(@Nonnull ProgressLogger pl, @Nonnull File audioFile) throws IOException, UnsupportedAudioFileException, LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException, TaskCanceledException {
        AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
        try {
            SpuAdpcmEncoder.Stereo encoder;
            AudioFormat fmt = ais.getFormat();
            boolean blnFormatEquals = Math.abs(fmt.getSampleRate() - (float)this._iSampleFramesPerSecond) < 1.0f;
            blnFormatEquals &= this.isStereo() && fmt.getChannels() == 2 || !this.isStereo() && fmt.getChannels() == 1;
            if (!(blnFormatEquals &= ais.getFrameLength() == this.getSampleFrameCount())) {
                throw new LocalizedIncompatibleException(I.AUDIO_REPLACE_FORMAT_MISMATCH(ais.getFrameLength(), fmt.getChannels(), fmt.getSampleRate(), this.getSampleFrameCount(), this.isStereo() ? 2 : 1, this.getSampleFramesPerSecond()));
            }
            try {
                encoder = new SpuAdpcmEncoder.Stereo(ais);
            }
            catch (IncompatibleException ex) {
                throw new RuntimeException("This should have already been checked above", ex);
            }
            PairCollector pairCollector = new PairCollector();
            SquareAudioSectorToSquareAudioSectorPair sas2sasp = new SquareAudioSectorToSquareAudioSectorPair(SectorRange.ALL, pairCollector);
            SectorClaimSystem it = this.createClaimSystem();
            it.addIdListener(sas2sasp);
            int iSoundUnitsReplaced = 0;
            int iSomewhatAccurateSectorProgress = this.getStartSector();
            pl.progressStart(this._iSoundUnitCount);
            while (iSoundUnitsReplaced < this._iSoundUnitCount) {
                it.next(pl);
                while (pairCollector.hasNext()) {
                    SquareAudioSectorPair pair = pairCollector.next();
                    iSoundUnitsReplaced += pair.replace(encoder, this._iSoundUnitCount - iSoundUnitsReplaced, this.getSourceCd(), pl);
                    iSomewhatAccurateSectorProgress = pair.getEndSector();
                }
                if (pl.isSeekingEvent()) {
                    pl.event(I.CMD_PATCHING_SECTOR_NUMBER(iSomewhatAccurateSectorProgress));
                }
                pl.progressUpdate(iSoundUnitsReplaced);
            }
            pl.progressEnd();
        }
        finally {
            IO.closeSilently(ais, LOG);
        }
    }

    private static class PairCollector
    implements SquareAudioSectorToSquareAudioSectorPair.Listener,
    Iterator<SquareAudioSectorPair> {
        private final LinkedList<SquareAudioSectorPair> _pairs = new LinkedList();

        private PairCollector() {
        }

        @Override
        public boolean hasNext() {
            return !this._pairs.isEmpty();
        }

        @Override
        @Nonnull
        public SquareAudioSectorPair next() throws NoSuchElementException {
            return this._pairs.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pairDone(@Nonnull SquareAudioSectorPair pair, @Nonnull ILocalizedLogger log) {
            this._pairs.add(pair);
        }

        @Override
        public void endOfSectors(@Nonnull ILocalizedLogger log) {
            LOG.warning("Why are we hitting end of sectors while replacing?");
        }
    }

    private class SquareConverter
    implements ISectorAudioDecoder {
        @Nonnull
        private final SquareAudioSectorPairToAudioPacket _p2p;
        @Nonnull
        private final SquareAudioSectorToSquareAudioSectorPair _sa2p;

        public SquareConverter(double dblVolume) {
            this._p2p = new SquareAudioSectorPairToAudioPacket(dblVolume);
            this._sa2p = new SquareAudioSectorToSquareAudioSectorPair(DiscItemSquareAudioStream.this.makeSectorRange(), this._p2p);
        }

        @Override
        public void setAudioListener(@Nonnull DecodedAudioPacket.Listener listener) {
            this._p2p.setListener(listener);
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            scs.addIdListener(this._sa2p);
        }

        @Override
        public double getVolume() {
            return this._p2p.getVolume();
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat() {
            return this._p2p.getFormat(DiscItemSquareAudioStream.this._iSampleFramesPerSecond);
        }

        @Override
        public int getSampleFramesPerSecond() {
            return DiscItemSquareAudioStream.this._iSampleFramesPerSecond;
        }

        @Override
        public int getDiscSpeed() {
            return 2;
        }

        @Override
        public int getEndSector() {
            return DiscItemSquareAudioStream.this.getEndSector();
        }

        @Override
        public int getStartSector() {
            return DiscItemSquareAudioStream.this.getStartSector();
        }

        @Override
        public int getAbsolutePresentationStartSector() {
            return DiscItemSquareAudioStream.this.getPresentationStartSector();
        }
    }
}

