/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.square.DiscItemSquareAudioStream;
import jpsxdec.modules.square.SquareAudioSectorPair;
import jpsxdec.modules.square.SquareAudioSectorToSquareAudioSectorPair;

public class DiscIndexerSquareAudio
extends DiscIndexer
implements SquareAudioSectorToSquareAudioSectorPair.Listener {
    @Nonnull
    private final ILocalizedLogger _errLog;
    private final SquareAudioSectorToSquareAudioSectorPair _sas2sasp = new SquareAudioSectorToSquareAudioSectorPair(SectorRange.ALL, this);
    @CheckForNull
    private AudioBuilder _audBldr;

    public DiscIndexerSquareAudio(@Nonnull ILocalizedLogger errLog) {
        this._errLog = errLog;
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("SquareAudio".equals(fields.getType())) {
            return new DiscItemSquareAudioStream(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this._sas2sasp);
    }

    @Override
    public void pairDone(@Nonnull SquareAudioSectorPair pair, @Nonnull ILocalizedLogger log) {
        boolean ok;
        if (pair.getSoundUnitCount() == 0) {
            return;
        }
        if (this._audBldr != null && !(ok = this._audBldr.pairDone(pair))) {
            this.addDiscItem(this._audBldr.makeStream(this.getCd()));
            this._audBldr = null;
        }
        if (this._audBldr == null) {
            this._audBldr = new AudioBuilder(pair);
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
        if (this._audBldr != null) {
            this.addDiscItem(this._audBldr.makeStream(this.getCd()));
            this._audBldr = null;
        }
    }

    @Override
    public void listPostProcessing(Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(DiscIndex index) {
    }

    private static class AudioBuilder {
        private final int _iSampleFramesPerSecond;
        private final int _iStartSector;
        private int _iEndSector;
        private int _iSoundUnitCount;
        @Nonnull
        private SquareAudioSectorPair _prevPair;
        private int _iMinimumSectorsBetweenPair = -1;

        public AudioBuilder(@Nonnull SquareAudioSectorPair firstPair) {
            this._prevPair = firstPair;
            this._iSampleFramesPerSecond = firstPair.getSampleFramesPerSecond();
            this._iStartSector = firstPair.getStartSector();
            this._iEndSector = firstPair.getEndSector();
            this._iSoundUnitCount = firstPair.getSoundUnitCount();
        }

        public boolean pairDone(@Nonnull SquareAudioSectorPair pair) {
            if (!pair.matchesPrevious(this._prevPair)) {
                return false;
            }
            this._iSoundUnitCount += pair.getSoundUnitCount();
            this._iEndSector = pair.getEndSector();
            int iSectorsBetweenPair = pair.getStartSector() - this._prevPair.getEndSector();
            this._iMinimumSectorsBetweenPair = this._iMinimumSectorsBetweenPair < 0 ? iSectorsBetweenPair : Math.min(this._iMinimumSectorsBetweenPair, iSectorsBetweenPair);
            this._prevPair = pair;
            return true;
        }

        @Nonnull
        public DiscItemSquareAudioStream makeStream(@Nonnull CdFileSectorReader cd) {
            int iSectorsPastEnd = 1;
            if (this._iMinimumSectorsBetweenPair >= 0) {
                iSectorsPastEnd = this._iMinimumSectorsBetweenPair;
            }
            return new DiscItemSquareAudioStream(cd, this._iStartSector, this._iEndSector, this._iSoundUnitCount, this._iSampleFramesPerSecond, iSectorsPastEnd);
        }
    }
}

