/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.spu;

import com.jhlabs.awt.ParagraphLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import jpsxdec.discitems.CombinedBuilderListener;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.discitems.ParagraphPanel;
import jpsxdec.i18n.I;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.modules.spu.SpuSaverBuilder;

public class SpuSaverBuilderGui
extends DiscItemSaverBuilderGui {
    @Nonnull
    private final CombinedBuilderListener<SpuSaverBuilder> _bl;
    @Nonnull
    private final PPanel _ppanel;
    @Nonnull
    private final JButton _btnPreviewStop;
    @Nonnull
    private final JCheckBox _chkAutoPlay;
    @Nonnull
    private final ButtonSetter _btnSetter;
    @CheckForNull
    private ItemPlayer _itemPlayer = null;

    public SpuSaverBuilderGui(@Nonnull SpuSaverBuilder sourceBldr) {
        super(new GridBagLayout());
        this._bl = new CombinedBuilderListener<SpuSaverBuilder>(sourceBldr);
        this._btnPreviewStop = new JButton("Preview");
        this._chkAutoPlay = new JCheckBox("Auto play");
        this._btnSetter = new ButtonSetter(this._btnPreviewStop);
        this._ppanel = new PPanel(this._bl);
        this.initComponents();
    }

    private void initComponents() {
        int iMargin;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.add((Component)this._ppanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        ParagraphLayout pLayout = (ParagraphLayout)this._ppanel.getLayout();
        gbc.insets.left = iMargin = pLayout.getHMargin();
        gbc.insets.right = iMargin;
        this.add((Component)this._btnPreviewStop, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.insets.left = iMargin;
        gbc.insets.right = iMargin;
        this.add((Component)this._chkAutoPlay, gbc);
        this._btnPreviewStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpuSaverBuilderGui.this.previewStopButtonClick(e);
            }
        });
    }

    @Override
    public boolean useSaverBuilder(@Nonnull DiscItemSaverBuilder saverBuilder) {
        boolean blnIsMatch;
        ItemPlayer ip = this._itemPlayer;
        if (ip != null) {
            ip.action(Action.STOP);
            this._itemPlayer = null;
        }
        if ((blnIsMatch = this._bl.changeSourceBuilder(saverBuilder)) && this._chkAutoPlay.isSelected()) {
            this._itemPlayer = new ItemPlayer(this._btnSetter, this._bl.getBuilder());
            this._itemPlayer.action(Action.PLAY);
        }
        return blnIsMatch;
    }

    private void previewStopButtonClick(ActionEvent e) {
        if (this._itemPlayer == null) {
            this._itemPlayer = new ItemPlayer(this._btnSetter, this._bl.getBuilder());
        }
        this._itemPlayer.action(Action.TOGGLE);
    }

    private static class PPanel
    extends ParagraphPanel {
        private final CombinedBuilderListener<SpuSaverBuilder> _bl;

        public PPanel(CombinedBuilderListener<SpuSaverBuilder> bl) {
            this._bl = bl;
            this._bl.addListeners(new AudioFormat(), new SampleRate());
        }

        private class SampleRate
        extends ParagraphPanel.AbstractCombo {
            public SampleRate() {
                super(new UnlocalizedMessage("Sample rate:"), false);
                this.__combo.setEditable(true);
            }

            @Override
            public int getSize() {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getSampleRate_listSize();
            }

            @Override
            public Object getElementAt(int index) {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getSampleRate_listItem(index);
            }

            @Override
            public void setSelectedItem(Object anItem) {
                int iSampleRate = ((Number)anItem).intValue();
                ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).setSampleRate(iSampleRate);
            }

            @Override
            public Object getSelectedItem() {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getSampleRate();
            }

            @Override
            protected boolean getEnabled() {
                return true;
            }
        }

        protected class AudioFormat
        extends ParagraphPanel.AbstractComboExtension {
            public AudioFormat() {
                super(I.GUI_SAVE_AS_LABEL(), ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getFileBaseName());
            }

            @Override
            public int getSize() {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getContainerFormat_listSize();
            }

            @Override
            public Object getElementAt(int index) {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getContainerFormat_listItem(index);
            }

            @Override
            public void setSelectedItem(Object anItem) {
                ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).setContainerForamt((SpuSaverBuilder.SpuSaverFormat)anItem);
            }

            @Override
            public Object getSelectedItem() {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getContainerFormat();
            }

            @Override
            public String getBaseName() {
                return ((SpuSaverBuilder)PPanel.this._bl.getBuilder()).getFileBaseName();
            }
        }
    }

    private static class ButtonSetter
    implements Runnable {
        @Nonnull
        private final JButton _btn;
        private boolean _blnShowPreview = true;

        public ButtonSetter(@Nonnull JButton btn) {
            this._btn = btn;
        }

        public synchronized void action(@Nonnull Action act) {
            switch (act) {
                case PLAY: {
                    this._blnShowPreview = false;
                    break;
                }
                case STOP: {
                    this._blnShowPreview = true;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            if (this._blnShowPreview) {
                this._btn.setText("Preview");
            } else {
                this._btn.setText("Stop");
            }
        }
    }

    private static class ItemPlayer {
        @Nonnull
        private final ButtonSetter _btnSetter;
        @Nonnull
        private final SpuSaverBuilder _builder;
        @CheckForNull
        private PlayInstance _playInstance;

        public ItemPlayer(@Nonnull ButtonSetter bs, @Nonnull SpuSaverBuilder builder) {
            this._btnSetter = bs;
            this._builder = builder;
        }

        public void play() {
            this.action(Action.PLAY);
        }

        public void stop() {
            this.action(Action.STOP);
        }

        public void toggle() {
            this.action(Action.TOGGLE);
        }

        private synchronized void action(@Nonnull Action act) {
            boolean blnWasPlaying = false;
            if (this._playInstance != null) {
                blnWasPlaying = !this._playInstance.isDone();
                this._playInstance.stop();
                this._playInstance = null;
            }
            if (act == Action.PLAY || act == Action.TOGGLE && !blnWasPlaying) {
                this._playInstance = PlayInstance.startPlaying(this._btnSetter, this._builder);
            }
        }

        private static class PlayInstance
        implements Runnable {
            @Nonnull
            private final ButtonSetter _bs;
            @Nonnull
            private final SpuSaverBuilder _bldr;
            @CheckForNull
            private Clip _clip;
            private boolean _blnIsDone = false;

            private PlayInstance(@Nonnull ButtonSetter bs, @Nonnull SpuSaverBuilder bldr) {
                this._bs = bs;
                this._bldr = bldr;
            }

            public static PlayInstance startPlaying(@Nonnull ButtonSetter bs, @Nonnull SpuSaverBuilder bldr) {
                PlayInstance pi = new PlayInstance(bs, bldr);
                pi.openAndStart();
                Thread t = new Thread((Runnable)pi, "Play" + bldr.getFileBaseName());
                t.start();
                return pi;
            }

            private void openAndStart() {
                try {
                    if (!this._blnIsDone) {
                        double t1 = (double)System.currentTimeMillis() / 1000.0;
                        this._clip = AudioSystem.getClip();
                        double t2 = (double)System.currentTimeMillis() / 1000.0;
                        if (t2 - t1 > 0.5) {
                            System.out.format("%s.getClip() hung for %.2f", Thread.currentThread().getName(), t2 - t1).println();
                        }
                        this._clip.open(this._bldr.getAudioStream());
                        double t3 = (double)System.currentTimeMillis() / 1000.0;
                        if (t3 - t2 > 0.5) {
                            System.out.format("%s.open() hung for %.2f", Thread.currentThread().getName(), t3 - t2).println();
                        }
                        this._clip.start();
                        double t4 = (double)System.currentTimeMillis() / 1000.0;
                        if (t4 - t3 > 0.5) {
                            System.out.format("%s.start() hung for %.2f", Thread.currentThread().getName(), t3 - t2).println();
                        }
                        this._bs.action(Action.PLAY);
                        double t5 = (double)System.currentTimeMillis() / 1000.0;
                    }
                }
                catch (LineUnavailableException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    while (!this._clip.isRunning() && !this._blnIsDone) {
                        Thread.sleep(100L);
                    }
                    while (this._clip.isRunning() && !this._blnIsDone) {
                        Thread.sleep(100L);
                    }
                    if (!this._blnIsDone) {
                        this._bs.action(Action.STOP);
                    }
                    this._blnIsDone = true;
                    if (this._clip == null) return;
                }
                catch (InterruptedException ex) {
                    try {
                        ex.printStackTrace();
                        if (this._clip == null) return;
                    }
                    catch (Throwable throwable) {
                        if (this._clip == null) throw throwable;
                        double t1 = (double)System.currentTimeMillis() / 1000.0;
                        this._clip.stop();
                        double t2 = (double)System.currentTimeMillis() / 1000.0;
                        if (t2 - t1 > 0.5) {
                            System.out.format("%s.stop() hung for %.2f", Thread.currentThread().getName(), t2 - t1).println();
                        }
                        this._clip.flush();
                        double t3 = (double)System.currentTimeMillis() / 1000.0;
                        if (t3 - t2 > 0.5) {
                            System.out.format("%s.flush() hung for %.2f", Thread.currentThread().getName(), t3 - t2).println();
                        }
                        this._clip.close();
                        double t4 = (double)System.currentTimeMillis() / 1000.0;
                        if (!(t4 - t3 > 0.5)) throw throwable;
                        System.out.format("%s.close() hung for %.2f", Thread.currentThread().getName(), t4 - t3).println();
                        throw throwable;
                    }
                    double t1 = (double)System.currentTimeMillis() / 1000.0;
                    this._clip.stop();
                    double t2 = (double)System.currentTimeMillis() / 1000.0;
                    if (t2 - t1 > 0.5) {
                        System.out.format("%s.stop() hung for %.2f", Thread.currentThread().getName(), t2 - t1).println();
                    }
                    this._clip.flush();
                    double t3 = (double)System.currentTimeMillis() / 1000.0;
                    if (t3 - t2 > 0.5) {
                        System.out.format("%s.flush() hung for %.2f", Thread.currentThread().getName(), t3 - t2).println();
                    }
                    this._clip.close();
                    double t4 = (double)System.currentTimeMillis() / 1000.0;
                    if (!(t4 - t3 > 0.5)) return;
                    System.out.format("%s.close() hung for %.2f", Thread.currentThread().getName(), t4 - t3).println();
                    return;
                }
                double t1 = (double)System.currentTimeMillis() / 1000.0;
                this._clip.stop();
                double t2 = (double)System.currentTimeMillis() / 1000.0;
                if (t2 - t1 > 0.5) {
                    System.out.format("%s.stop() hung for %.2f", Thread.currentThread().getName(), t2 - t1).println();
                }
                this._clip.flush();
                double t3 = (double)System.currentTimeMillis() / 1000.0;
                if (t3 - t2 > 0.5) {
                    System.out.format("%s.flush() hung for %.2f", Thread.currentThread().getName(), t3 - t2).println();
                }
                this._clip.close();
                double t4 = (double)System.currentTimeMillis() / 1000.0;
                if (!(t4 - t3 > 0.5)) return;
                System.out.format("%s.close() hung for %.2f", Thread.currentThread().getName(), t4 - t3).println();
                return;
            }

            public boolean isDone() {
                return this._blnIsDone;
            }

            public void stop() {
                this._blnIsDone = true;
                this._bs.action(Action.STOP);
            }
        }
    }

    private static enum Action {
        PLAY,
        STOP,
        TOGGLE;

    }
}

