/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.spu;

import argparser.StringHolder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import jpsxdec.adpcm.VagWriter;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.formats.JavaAudioFormat;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.spu.DiscItemSpu;
import jpsxdec.modules.spu.SpuSaverBuilderGui;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;

public class SpuSaverBuilder
extends DiscItemSaverBuilder {
    private static final Logger LOG = Logger.getLogger(SpuSaverBuilder.class.getName());
    private static final int[] DEFAULT_SAMPLE_RATES = new int[]{8000, 11025, 16000, 18900, 22050, 24000, 32000, 37800, 44100, 48000};
    private static final SpuSaverFormat SPU = new SpuSaverFormat("spu", I.SPU_EXTENSION_DESCRIPTION());
    private static final SpuSaverFormat VAG = new SpuSaverFormat("vag", I.VAG_EXTENSION_DESCRIPTION());
    private static final ArrayList<SpuSaverFormat> AUDIO_FORMATS;
    @Nonnull
    private final DiscItemSpu _spuItem;
    @Nonnull
    private SpuSaverFormat _containerFormat = AUDIO_FORMATS.get(0);
    private double _dblVolume = 1.0;

    private static SpuSaverFormat fromCmdLine(String s) {
        for (SpuSaverFormat fmt : AUDIO_FORMATS) {
            if (!fmt.getCmdId().equalsIgnoreCase(s)) continue;
            return fmt;
        }
        return null;
    }

    public SpuSaverBuilder(@Nonnull DiscItemSpu spuItem) {
        this._spuItem = spuItem;
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder other) {
        if (other instanceof SpuSaverBuilder) {
            SpuSaverBuilder o = (SpuSaverBuilder)other;
            o.setContainerForamt(this.getContainerFormat());
            o.setVolume(this.getVolume());
            o.setSampleRate(this.getSampleRate());
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public DiscItemSpu getDiscItem() {
        return this._spuItem;
    }

    public int getSampleRate() {
        return this._spuItem.getSampleRate();
    }

    public void setSampleRate(int iSampleRate) {
        this._spuItem.setSampleRate(iSampleRate);
        this.firePossibleChange();
    }

    public int getSampleRate_listSize() {
        return DEFAULT_SAMPLE_RATES.length;
    }

    public int getSampleRate_listItem(int i) {
        return DEFAULT_SAMPLE_RATES[i];
    }

    public void setContainerForamt(@Nonnull SpuSaverFormat val) {
        this._containerFormat = val;
        this.firePossibleChange();
    }

    @Nonnull
    public SpuSaverFormat getContainerFormat() {
        return this._containerFormat;
    }

    public int getContainerFormat_listSize() {
        return AUDIO_FORMATS.size();
    }

    @Nonnull
    public SpuSaverFormat getContainerFormat_listItem(int i) {
        return AUDIO_FORMATS.get(i);
    }

    @Nonnull
    public String getExtension() {
        return this.getContainerFormat().getExtension();
    }

    @Nonnull
    public String getFileBaseName() {
        return this._spuItem.getSuggestedBaseName().getPath();
    }

    public void setVolume(double val) {
        this._dblVolume = val;
        this.firePossibleChange();
    }

    public double getVolume() {
        if (this.getVolume_enabled()) {
            return this._dblVolume;
        }
        return 1.0;
    }

    public boolean getVolume_enabled() {
        return this.getContainerFormat().getJavaType() != null;
    }

    @Nonnull
    public AudioInputStream getAudioStream() {
        return this._spuItem.getAudioStream(this.getVolume());
    }

    @Nonnull
    private File getFileRelativePath() {
        return new File(this._spuItem.getSuggestedBaseName().getPath() + "." + this.getExtension());
    }

    @Override
    public void printHelp(@Nonnull FeedbackStream fbs) {
        TabularFeedback tfb = new TabularFeedback();
        tfb.setRowSpacing(1);
        tfb.addCell(I.CMD_AUDIO_AF());
        TabularFeedback.Cell c = new TabularFeedback.Cell(I.CMD_AUDIO_AF_HELP(AUDIO_FORMATS.get(0).getExtension()));
        for (SpuSaverFormat saveFormat : AUDIO_FORMATS) {
            c.addLine(saveFormat.getCmdId(), 2);
        }
        tfb.addCell(c);
        tfb.newRow();
        tfb.addCell(I.CMD_AUDIO_VOL()).addCell(I.CMD_AUDIO_VOL_HELP(100));
        tfb.write(fbs.getUnderlyingStream());
    }

    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        if (!ap.hasRemaining()) {
            return;
        }
        StringHolder vol = ap.addStringOption("-vol");
        StringHolder audfmt = ap.addStringOption("-audfmt", "-af");
        StringHolder sampleRate = ap.addStringOption("-samplerate", "-sr");
        ap.match();
        if (vol.value != null) {
            try {
                int iVol = Integer.parseInt(vol.value);
                if (iVol < 0 || iVol > 100) {
                    throw new NumberFormatException();
                }
                this.setVolume((double)iVol / 100.0);
            }
            catch (NumberFormatException ex) {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VOLUME(vol.value));
            }
        }
        if (audfmt.value != null) {
            SpuSaverFormat fmt = SpuSaverBuilder.fromCmdLine(audfmt.value);
            if (fmt != null) {
                this.setContainerForamt(fmt);
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_FORMAT(audfmt.value));
            }
        }
        if (sampleRate.value != null) {
            // empty if block
        }
    }

    @Override
    public void printSelectedOptions(@Nonnull ILocalizedLogger log) {
        SpuSaverFormat fmt = this.getContainerFormat();
        JavaAudioFormat jFmt = fmt.getJavaType();
        if (jFmt != null) {
            log.log(Level.INFO, I.CMD_VOLUME_PERCENT(this._dblVolume));
            log.log(Level.INFO, I.CMD_AUDIO_FORMAT(jFmt.getCmdId()));
        }
        log.log(Level.INFO, I.CMD_FILENAME(this.getFileRelativePath()));
    }

    @Override
    @Nonnull
    public ILocalizedMessage getOutputSummary() {
        return new UnlocalizedMessage(this.getFileRelativePath().getPath());
    }

    @Override
    @Nonnull
    public DiscItemSaverBuilderGui getOptionPane() {
        return new SpuSaverBuilderGui(this);
    }

    @Override
    public void startSave(@Nonnull ProgressLogger pl, @CheckForNull File directory) throws LoggedFailure, TaskCanceledException {
        this.clearGeneratedFiles();
        this.printSelectedOptions(pl);
        pl.progressStart(1.0);
        File outputFile = new File(directory, this.getFileRelativePath().getPath());
        try {
            IO.makeDirsForFile(outputFile);
        }
        catch (LocalizedFileNotFoundException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, ex.getSourceMessage(), ex);
        }
        SpuSaverFormat fmt = this.getContainerFormat();
        JavaAudioFormat jFmt = fmt.getJavaType();
        if (jFmt != null) {
            this.startSaveJavaAudio(pl, outputFile, jFmt.getJavaType());
        } else {
            this.startSaveSpu(pl, outputFile, fmt);
        }
        pl.progressEnd();
    }

    private void startSaveJavaAudio(@Nonnull ProgressLogger pl, @Nonnull File outputFile, @Nonnull AudioFileFormat.Type audioFileType) throws LoggedFailure {
        AudioInputStream ais = this._spuItem.getAudioStream(this._dblVolume);
        try {
            this.addGeneratedFile(outputFile);
            AudioSystem.write(ais, audioFileType, outputFile);
        }
        catch (IOException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_FILE_ERROR_NAME(outputFile.toString()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSaveSpu(@Nonnull ProgressLogger pl, @Nonnull File outputFile, @Nonnull SpuSaverFormat fmt) throws LoggedFailure {
        ISaveSpu saver;
        if (fmt == SPU) {
            saver = new SaveSpuFile();
        } else if (fmt == VAG) {
            saver = new SaveVagFile();
        } else {
            throw new RuntimeException();
        }
        this.addGeneratedFile(outputFile);
        saver.open(this._spuItem, outputFile, pl);
        InputStream spu = null;
        try {
            spu = this._spuItem.getSpuStream();
            byte[] ab = new byte[16];
            for (int i = 0; i < this._spuItem.getSoundUnitCount(); ++i) {
                try {
                    IO.readByteArray(spu, ab);
                }
                catch (IOException ex) {
                    throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(this._spuItem.getSourceCd().getSourceFile().toString()), ex);
                }
                try {
                    saver.writeSoundUnit(ab);
                    continue;
                }
                catch (IOException ex) {
                    throw new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(outputFile.toString()), ex);
                }
            }
        }
        finally {
            IO.closeSilently(spu, LOG);
            IO.closeSilently(saver, LOG);
        }
    }

    static {
        JavaAudioFormat[] availableFormats = JavaAudioFormat.getAudioFormats();
        AUDIO_FORMATS = new ArrayList(availableFormats.length + 2);
        for (JavaAudioFormat fmt : availableFormats) {
            AUDIO_FORMATS.add(new SpuSaverFormat(fmt));
        }
        AUDIO_FORMATS.add(SPU);
        AUDIO_FORMATS.add(VAG);
    }

    private static class SaveVagFile
    implements ISaveSpu {
        @CheckForNull
        private VagWriter _vag;

        private SaveVagFile() {
        }

        @Override
        public void open(@Nonnull DiscItemSpu spuItem, @Nonnull File outputFile, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            try {
                this._vag = new VagWriter(outputFile, SaveVagFile.makeId(spuItem), spuItem.getSampleRate());
            }
            catch (FileNotFoundException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(outputFile.toString()), ex);
            }
            catch (IOException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(outputFile.toString()), ex);
            }
        }

        @Override
        public void writeSoundUnit(byte[] abSoundUnit) throws IOException {
            this._vag.writeSoundUnit(abSoundUnit);
        }

        @Override
        public void close() throws IOException {
            this._vag.close();
        }

        @Nonnull
        private static String makeId(@Nonnull DiscItemSpu spu) {
            File baseName = spu.getSuggestedBaseName();
            String sName = baseName.getName();
            String sCleanName = sName.replaceAll("[^\\w\\d]", "");
            return sCleanName.substring(0, Math.min(sCleanName.length(), 16));
        }
    }

    private static class SaveSpuFile
    implements ISaveSpu {
        @CheckForNull
        private FileOutputStream _fos;

        private SaveSpuFile() {
        }

        @Override
        public void open(@Nonnull DiscItemSpu spuItem, @Nonnull File outputFile, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            try {
                this._fos = new FileOutputStream(outputFile);
            }
            catch (FileNotFoundException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(outputFile.toString()), ex);
            }
        }

        @Override
        public void writeSoundUnit(byte[] abSoundUnit) throws IOException {
            this._fos.write(abSoundUnit);
        }

        @Override
        public void close() throws IOException {
            this._fos.close();
        }
    }

    private static interface ISaveSpu
    extends Closeable {
        public void open(@Nonnull DiscItemSpu var1, @Nonnull File var2, @Nonnull ILocalizedLogger var3) throws LoggedFailure;

        public void writeSoundUnit(@Nonnull byte[] var1) throws IOException;
    }

    public static class SpuSaverFormat {
        @CheckForNull
        private final JavaAudioFormat _jFmt;
        @Nonnull
        private final String _sExtension;
        @Nonnull
        private final ILocalizedMessage _cmdId;
        @Nonnull
        private final ILocalizedMessage _guiDotExtensionDescription;

        private SpuSaverFormat(@Nonnull String sExtension, @Nonnull ILocalizedMessage guiDotExtensionDescription) {
            this._jFmt = null;
            this._sExtension = sExtension;
            this._cmdId = new UnlocalizedMessage(this._sExtension);
            this._guiDotExtensionDescription = guiDotExtensionDescription;
        }

        private SpuSaverFormat(@Nonnull JavaAudioFormat jFmt) {
            this._jFmt = jFmt;
            this._sExtension = null;
            this._cmdId = null;
            this._guiDotExtensionDescription = null;
        }

        @CheckForNull
        public JavaAudioFormat getJavaType() {
            return this._jFmt;
        }

        @Nonnull
        public String getExtension() {
            if (this._jFmt != null) {
                return this._jFmt.getExtension();
            }
            return this._sExtension;
        }

        public String toString() {
            if (this._jFmt != null) {
                return this._jFmt.toString();
            }
            return this._guiDotExtensionDescription.toString();
        }

        @Nonnull
        public ILocalizedMessage getCmdId() {
            if (this._jFmt != null) {
                return this._jFmt.getCmdId();
            }
            return this._cmdId;
        }
    }
}

