/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.spu;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DemuxedSectorInputStream;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.modules.spu.SpuSaverBuilder;
import jpsxdec.util.ExposedBAOS;
import jpsxdec.util.Misc;

public class DiscItemSpu
extends DiscItem
implements DiscItem.IHasStartOffset {
    public static final String TYPE_ID = "SPU";
    private static final int DEFAULT_SAMPLE_RATE = 22050;
    private static final String START_OFFSET_KEY = "Start Offset";
    private final int _iStartOffset;
    private static final String END_OFFSET_KEY = "End Offset";
    private final int _iEndOffset;
    private static final String SOUNDUNIT_COUNT_KEY = "Sound Unit Count";
    private final int _iSoundUnitCount;
    private static final String SAMPLE_RATE_KEY = "Sample Rate";
    private int _iSampleRate;

    public DiscItemSpu(@Nonnull CdFileSectorReader cd, int iStartSector, int iStartOffset, int iEndSector, int iEndOffset, int iSoundUnitCount) {
        super(cd, iStartSector, iEndSector);
        this._iStartOffset = iStartOffset;
        this._iEndOffset = iEndOffset;
        this._iSoundUnitCount = iSoundUnitCount;
        this._iSampleRate = 22050;
    }

    public DiscItemSpu(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._iStartOffset = fields.getInt(START_OFFSET_KEY);
        this._iEndOffset = fields.getInt(END_OFFSET_KEY);
        this._iSoundUnitCount = fields.getInt(SOUNDUNIT_COUNT_KEY);
        this._iSampleRate = fields.getInt(SAMPLE_RATE_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem ser = super.serialize();
        ser.addNumber(START_OFFSET_KEY, this._iStartOffset);
        ser.addNumber(END_OFFSET_KEY, this._iEndOffset);
        ser.addNumber(SOUNDUNIT_COUNT_KEY, this._iSoundUnitCount);
        ser.addNumber(SAMPLE_RATE_KEY, this._iSampleRate);
        return ser;
    }

    @Override
    public int getStartOffset() {
        return this._iStartOffset;
    }

    public int getSoundUnitCount() {
        return this._iSoundUnitCount;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    @Nonnull
    public DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.Sound;
    }

    public int getSampleRate() {
        return this._iSampleRate;
    }

    public void setSampleRate(int iSampleRate) {
        this._iSampleRate = iSampleRate;
    }

    @Nonnull
    public AudioFormat getFormat() {
        return new AudioFormat(this._iSampleRate, 16, 1, true, false);
    }

    @Override
    @Nonnull
    public ILocalizedMessage getInterestingDescription() {
        int iPcmSampleCount = this._iSoundUnitCount * 28;
        double dblApproxDuration = (double)iPcmSampleCount / (double)this._iSampleRate;
        Date secs = Misc.dateFromSeconds(Math.max((int)dblApproxDuration, 1));
        return new UnlocalizedMessage(MessageFormat.format("{0} samples at {1} Hz = {2,time,m:ss}", iPcmSampleCount, this._iSampleRate, secs));
    }

    @Override
    @Nonnull
    public SpuSaverBuilder makeSaverBuilder() {
        return new SpuSaverBuilder(this);
    }

    @Nonnull
    public InputStream getSpuStream() {
        return new DemuxedSectorInputStream(this.getSourceCd(), this.getStartSector(), this.getStartOffset());
    }

    @Nonnull
    public AudioInputStream getAudioStream(double dblVolume) {
        InputStream stream = this.getSpuStream();
        SpuInputStream spuStream = new SpuInputStream(stream, dblVolume);
        AudioInputStream ais = new AudioInputStream(spuStream, this.getFormat(), (long)this._iSoundUnitCount * 28L);
        return ais;
    }

    private static class SpuInputStream
    extends InputStream {
        private static final int BYTES_PER_SOUND_UNIT = 56;
        @Nonnull
        private final InputStream _spuIn;
        @Nonnull
        private final SpuAdpcmDecoder.Mono _decoder;
        private final ExposedBAOS _decodeBuffer = new ExposedBAOS(56);
        private int _iReadOfs = 56;

        public SpuInputStream(@Nonnull InputStream spuIn, double dblVolume) {
            this._spuIn = spuIn;
            this._decoder = new SpuAdpcmDecoder.Mono(dblVolume);
        }

        @Override
        public int read() throws IOException {
            if (this._iReadOfs >= 56) {
                this._decodeBuffer.reset();
                this._decoder.decode(this._spuIn, 1, this._decodeBuffer);
                this._iReadOfs = 0;
            }
            byte b = this._decodeBuffer.getBuffer()[this._iReadOfs];
            ++this._iReadOfs;
            return b & 0xFF;
        }
    }
}

