/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.spu;

import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.UnidentifiedSectorStreamListener;
import jpsxdec.modules.spu.DiscItemSpu;

public class DiscIndexerSpu
extends DiscIndexer
implements UnidentifiedSectorStreamListener.Listener {
    public static final boolean ENABLE_SPU_SUPPORT = false;
    private static final Logger LOG = Logger.getLogger(DiscIndexerSpu.class.getName());
    private static final int MIN_SOUND_UNIT_COUNT = 16;
    private final SpuRun[] _spuRuns = new SpuRun[4];
    private int _iRun = 0;

    @Override
    @CheckForNull
    public DiscItemSpu deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("SPU".equals(fields.getType())) {
            return new DiscItemSpu(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        UnidentifiedSectorStreamListener.attachToSectorClaimer(scs, this);
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    public DiscIndexerSpu() {
        for (int i = 0; i < this._spuRuns.length; ++i) {
            this._spuRuns[i] = new SpuRun();
        }
    }

    @Override
    public void feedSector(@Nonnull CdSector cdSector) {
        int iUserDataSize = cdSector.getCdUserDataSize();
        int iSector = cdSector.getSectorIndexFromStart();
        for (int iOfs = 0; iOfs < iUserDataSize; iOfs += 4) {
            if (iUserDataSize - iOfs < 4) {
                LOG.severe("WAT");
                throw new RuntimeException("SPU WIP");
            }
            int iQuad = cdSector.readSInt32BE(iOfs);
            int iRun = this._iRun;
            int iQuadIndex = 0;
            for (int i = 0; i < 4; ++i) {
                this._spuRuns[iRun].addQuad(iQuadIndex, iQuad, iSector, iOfs);
                iRun = (iRun + 1) % this._spuRuns.length;
                if (--iQuadIndex >= 0) continue;
                iQuadIndex = this._spuRuns.length - 1;
            }
            this._iRun = (this._iRun + 1) % this._spuRuns.length;
        }
    }

    @Override
    public void endOfUnidentified() {
        for (SpuRun run : this._spuRuns) {
            run.clearRun();
        }
    }

    private class SpuRun {
        private boolean _blnInRun = false;
        private int _iStartSector;
        private int _iStartOffset;
        private int _iEndSector;
        private int _iEndOffset;
        private int _iSoundUnitCount;
        private boolean _blnLastSoundUnit;
        private boolean _blnOnlyZeroes;

        private SpuRun() {
        }

        public void addQuad(int iQuadIndex, int iQuad, int iSector, int iOffset) {
            if (iQuadIndex == 0) {
                int iFilterRange = iQuad >> 24 & 0xFF;
                int iFlagBits = iQuad >> 16 & 0xFF;
                int iFilter = iFilterRange >> 4 & 0xF;
                int iRange = iFilterRange & 0xF;
                boolean blnIsSpuHeader = iFilter <= 4 && iRange <= 12 && iFlagBits <= 7;
                boolean blnIsEnd = false;
                if (blnIsSpuHeader) {
                    boolean bl = blnIsEnd = (iFlagBits & 1) != 0;
                }
                if (this._blnInRun) {
                    if (!blnIsSpuHeader) {
                        this.cancelRun();
                    } else if (blnIsEnd) {
                        this._blnLastSoundUnit = true;
                    }
                } else if (blnIsSpuHeader && iFilterRange != 0 && !blnIsEnd) {
                    this.startRun(iSector, iOffset);
                    this._blnOnlyZeroes = (iQuad & 0xFFFF) == 0;
                }
            } else if (this._blnInRun) {
                boolean bl = this._blnOnlyZeroes = this._blnOnlyZeroes && iQuad == 0;
                if (iQuadIndex == 3) {
                    this._iEndSector = iSector;
                    this._iEndOffset = iOffset + 3;
                    ++this._iSoundUnitCount;
                    if (this._blnLastSoundUnit) {
                        this.endRun();
                    }
                }
            }
        }

        private void cancelRun() {
            this._blnInRun = false;
        }

        private void startRun(int iSector, int iOffset) {
            this._iStartSector = iSector;
            this._iStartOffset = iOffset;
            this._iSoundUnitCount = 0;
            this._blnInRun = true;
            this._blnLastSoundUnit = false;
        }

        private void endRun() {
            assert (this._blnInRun);
            if (this._iSoundUnitCount >= 16 && !this._blnOnlyZeroes) {
                DiscIndexerSpu.this.addDiscItem(new DiscItemSpu(DiscIndexerSpu.this.getCd(), this._iStartSector, this._iStartOffset, this._iEndSector, this._iEndOffset, this._iSoundUnitCount));
            }
            this._blnInRun = false;
        }

        public void clearRun() {
            this._blnInRun = false;
        }
    }
}

