/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.sharedaudio;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.sound.sampled.UnsupportedAudioFileException;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.player.MediaPlayer;
import jpsxdec.modules.sharedaudio.AudioSaverBuilder;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.util.TaskCanceledException;
import jpsxdec.util.player.PlayController;

public abstract class DiscItemAudioStream
extends DiscItem {
    private boolean _blnIsPartOfVideo = false;

    public DiscItemAudioStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector) {
        super(cd, iStartSector, iEndSector);
    }

    public DiscItemAudioStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
    }

    public boolean overlaps(@Nonnull DiscItemAudioStream other) {
        if (this.getEndSector() + this.getSectorsPastEnd() < other.getStartSector()) {
            return false;
        }
        return other.getEndSector() + other.getSectorsPastEnd() >= this.getStartSector();
    }

    public boolean isPartOfVideo() {
        return this._blnIsPartOfVideo;
    }

    public void setPartOfVideo(boolean bln) {
        this._blnIsPartOfVideo = bln;
    }

    @Override
    @Nonnull
    public DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.Audio;
    }

    public abstract long getSampleFrameCount();

    public abstract int getSampleFramesPerSecond();

    public abstract boolean isStereo();

    public abstract int getDiscSpeed();

    @Nonnull
    public abstract ISectorAudioDecoder makeDecoder(double var1);

    public abstract int getSectorsPastEnd();

    public abstract int getPresentationStartSector();

    public abstract double getApproxDuration();

    public ILocalizedMessage getDetails() {
        return new UnlocalizedMessage(this.serialize().serialize());
    }

    @Nonnull
    public PlayController makePlayController() {
        return new MediaPlayer(this).getPlayController();
    }

    @Override
    @Nonnull
    public AudioSaverBuilder makeSaverBuilder() {
        return new AudioSaverBuilder(this);
    }

    public boolean hasSameFormat(@Nonnull DiscItemAudioStream other) {
        return this.getSampleFramesPerSecond() == other.getSampleFramesPerSecond() && this.isStereo() == other.isStereo();
    }

    public abstract void replace(@Nonnull ProgressLogger var1, @Nonnull File var2) throws IOException, UnsupportedAudioFileException, LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException, TaskCanceledException;
}

