/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.sharedaudio;

import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.util.Fraction;

public class DecodedAudioPacket {
    private final int _iChannel;
    @Nonnull
    private final AudioFormat _audioFmt;
    private final int _iSampleFrameCount;
    @Nonnull
    private final Fraction _presentationSector;
    @Nonnull
    private final byte[] _abData;

    public DecodedAudioPacket(int iChannel, @Nonnull AudioFormat audioFmt, @Nonnull Fraction presentationSector, @Nonnull byte[] abData) {
        if (abData.length % audioFmt.getFrameSize() != 0) {
            throw new IllegalArgumentException();
        }
        this._iChannel = iChannel;
        this._audioFmt = audioFmt;
        this._iSampleFrameCount = abData.length / audioFmt.getFrameSize();
        this._presentationSector = presentationSector;
        this._abData = abData;
    }

    public int getChannel() {
        return this._iChannel;
    }

    @Nonnull
    public AudioFormat getAudioFormat() {
        return this._audioFmt;
    }

    public int getSampleFrameCount() {
        return this._iSampleFrameCount;
    }

    @Nonnull
    public Fraction getPresentationSector() {
        return this._presentationSector;
    }

    @Nonnull
    public byte[] getData() {
        return this._abData;
    }

    public String toString() {
        return String.format("Channel %d format %s SampleFrameCount %d PresentationSector %s Data.length %d", this._iChannel, this._audioFmt, this._iSampleFrameCount, this._presentationSector, this._abData.length);
    }

    public static interface Listener {
        public void audioPacketComplete(@Nonnull DecodedAudioPacket var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;
    }
}

