/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.sharedaudio;

import argparser.StringHolder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.formats.JavaAudioFormat;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.sharedaudio.AudioSaverBuilderGui;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.util.ArgParser;
import jpsxdec.util.AudioOutputFileWriter;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;

public class AudioSaverBuilder
extends DiscItemSaverBuilder {
    private static final Logger LOG = Logger.getLogger(AudioSaverBuilder.class.getName());
    @Nonnull
    private final DiscItemAudioStream _audItem;
    @Nonnull
    private JavaAudioFormat _containerFormat;
    private double _dblVolume = 1.0;

    public AudioSaverBuilder(@Nonnull DiscItemAudioStream audItem) {
        this._audItem = audItem;
        JavaAudioFormat[] fmts = JavaAudioFormat.getAudioFormats();
        this._containerFormat = fmts.length > 0 ? fmts[0] : null;
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder other) {
        if (other instanceof AudioSaverBuilder) {
            AudioSaverBuilder o = (AudioSaverBuilder)other;
            o.setContainerForamt(this.getContainerFormat());
            o.setVolume(this.getVolume());
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public DiscItemAudioStream getDiscItem() {
        return this._audItem;
    }

    public void setContainerForamt(@Nonnull JavaAudioFormat val) {
        this._containerFormat = val;
        this.firePossibleChange();
    }

    @Nonnull
    public JavaAudioFormat getContainerFormat() {
        return this._containerFormat;
    }

    public int getContainerFormat_listSize() {
        return JavaAudioFormat.getAudioFormats().length;
    }

    @Nonnull
    public JavaAudioFormat getContainerFormat_listItem(int i) {
        return JavaAudioFormat.getAudioFormats()[i];
    }

    @Nonnull
    public String getExtension() {
        return this.getContainerFormat().getExtension();
    }

    @Nonnull
    public String getFileBaseName() {
        return this._audItem.getSuggestedBaseName().getPath();
    }

    public void setVolume(double val) {
        this._dblVolume = val;
        this.firePossibleChange();
    }

    public double getVolume() {
        return this._dblVolume;
    }

    @Nonnull
    private File getFileRelativePath() {
        return new File(this._audItem.getSuggestedBaseName().getPath() + "." + this.getExtension());
    }

    @Override
    public void printHelp(@Nonnull FeedbackStream fbs) {
        TabularFeedback tfb = new TabularFeedback();
        tfb.setRowSpacing(1);
        tfb.addCell(I.CMD_AUDIO_AF());
        TabularFeedback.Cell cell = new TabularFeedback.Cell(I.CMD_AUDIO_AF_HELP(JavaAudioFormat.getAudioFormats()[0].getExtension()));
        for (JavaAudioFormat audioFormat : JavaAudioFormat.getAudioFormats()) {
            cell.addLine(audioFormat.getCmdId(), 2);
        }
        tfb.addCell(cell);
        tfb.newRow();
        tfb.addCell(I.CMD_AUDIO_VOL()).addCell(I.CMD_AUDIO_VOL_HELP(100));
        tfb.write(fbs.getUnderlyingStream());
    }

    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        if (!ap.hasRemaining()) {
            return;
        }
        StringHolder vol = ap.addStringOption("-vol");
        StringHolder audfmt = ap.addStringOption("-audfmt", "-af");
        ap.match();
        if (vol.value != null) {
            try {
                int iVol = Integer.parseInt(vol.value);
                if (iVol < 0 || iVol > 100) {
                    throw new NumberFormatException();
                }
                this.setVolume((double)iVol / 100.0);
            }
            catch (NumberFormatException ex) {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(vol.value, "-vol"));
            }
        }
        if (audfmt.value != null) {
            JavaAudioFormat fmt = JavaAudioFormat.fromCmdLine(audfmt.value);
            if (fmt != null) {
                this.setContainerForamt(fmt);
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(audfmt.value, "-af,-audfmt"));
            }
        }
    }

    @Override
    public void printSelectedOptions(@Nonnull ILocalizedLogger log) {
        log.log(Level.INFO, I.CMD_AUDIO_FORMAT(this._containerFormat.getCmdId()));
        log.log(Level.INFO, I.CMD_VOLUME_PERCENT(this.getVolume()));
        log.log(Level.INFO, I.CMD_FILENAME(this.getFileRelativePath()));
    }

    @Override
    @Nonnull
    public ILocalizedMessage getOutputSummary() {
        return new UnlocalizedMessage(this.getFileRelativePath().getPath());
    }

    @Override
    @Nonnull
    public DiscItemSaverBuilderGui getOptionPane() {
        return new AudioSaverBuilderGui(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSave(final @Nonnull ProgressLogger pl, @CheckForNull File outputDir) throws LoggedFailure, TaskCanceledException {
        AudioOutputFileWriter audioWriter;
        this.clearGeneratedFiles();
        this.printSelectedOptions(pl);
        final File outputFile = new File(outputDir, this.getFileRelativePath().getPath());
        try {
            IO.makeDirsForFile(outputFile);
        }
        catch (LocalizedFileNotFoundException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, ex.getSourceMessage(), ex);
        }
        ISectorAudioDecoder decoder = this._audItem.makeDecoder(this.getVolume());
        AudioFormat audioFmt = decoder.getOutputFormat();
        try {
            audioWriter = new AudioOutputFileWriter(outputFile, audioFmt, this._containerFormat.getJavaType());
            this.addGeneratedFile(outputFile);
        }
        catch (IOException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_FILE_ERROR_NAME(outputFile.toString()), ex);
        }
        decoder.setAudioListener(new DecodedAudioPacket.Listener(){

            @Override
            public void audioPacketComplete(@Nonnull DecodedAudioPacket packet, @Nonnull ILocalizedLogger log) {
                try {
                    if (!packet.getAudioFormat().matches(audioWriter.getFormat())) {
                        throw new IllegalArgumentException();
                    }
                    byte[] abData = packet.getData();
                    audioWriter.write(abData, 0, abData.length);
                }
                catch (IOException ex) {
                    throw new UnwindException(new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(outputFile.toString()), ex));
                }
            }
        });
        try {
            SectorClaimSystem it = this._audItem.createClaimSystem();
            decoder.attachToSectorClaimer(it);
            pl.progressStart(this._audItem.getSectorLength());
            int iSector = 0;
            while (it.hasNext()) {
                try {
                    IIdentifiedSector identifiedSect = it.next(pl);
                }
                catch (CdFileSectorReader.CdReadException ex) {
                    throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
                }
                pl.progressUpdate(iSector);
                ++iSector;
            }
            pl.progressEnd();
        }
        finally {
            IO.closeSilently(audioWriter, LOG);
        }
    }

    private static class UnwindException
    extends RuntimeException {
        @Nonnull
        private final LoggedFailure _fail;

        public UnwindException(@Nonnull LoggedFailure fail) {
            this._fail = fail;
        }

        public LoggedFailure getFailure() {
            return this._fail;
        }
    }
}

