/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.policenauts.SPacketData;

public class SectorPolicenauts
extends IdentifiedSector
implements Iterable<SPacketData> {
    private boolean _blnIsEnd;
    @Nonnull
    private List<SPacketData> _packetsEndingInThisSector = Collections.emptyList();

    public SectorPolicenauts(@Nonnull CdSector cdSector, boolean blnIsEnd) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        this._blnIsEnd = blnIsEnd;
        this.setProbability(100);
    }

    @Override
    public String getTypeName() {
        return "Policenauts";
    }

    void setPacketsEndingInThisSector(@Nonnull List<SPacketData> packetsEndingInThisSector) {
        assert (this.endsInThisSector(packetsEndingInThisSector));
        this._packetsEndingInThisSector = packetsEndingInThisSector;
    }

    private boolean endsInThisSector(@Nonnull List<SPacketData> packetsEndingInThisSector) {
        for (SPacketData sPacketData : packetsEndingInThisSector) {
            if (sPacketData.getEndSectorInclusive() == this.getSectorNumber()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Iterator<SPacketData> iterator() {
        return this._packetsEndingInThisSector.iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTypeName()).append(' ').append(super.toString()).append(' ').append(this._packetsEndingInThisSector.size()).append(" finished packets [");
        for (int i = 0; i < this._packetsEndingInThisSector.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._packetsEndingInThisSector.get(i));
        }
        sb.append(']');
        if (this._blnIsEnd) {
            sb.append(" END");
        }
        return sb.toString();
    }
}

