/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.policenauts.SectorPolicenauts;

public class SectorPN_VMNK
extends SectorPolicenauts {
    public static final int WIDTH = 288;
    public static final int HEIGHT = 144;
    private static final byte[] VMNK_HEADER = new byte[]{86, 77, 78, 75, 1, 0, 0, 0, 1, 0, 0, 0, -16, 0, 0, 0, 0, 0, 4, 0, 16, 0, 0, 0, 16, 0, 0, 0};
    private int _iWidth;
    private int _iHeight;

    public SectorPN_VMNK(@Nonnull CdSector cdSector) {
        super(cdSector, false);
        int i;
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        for (i = 0; i < VMNK_HEADER.length; ++i) {
            if (cdSector.readUserDataByte(i) == VMNK_HEADER[i]) continue;
            return;
        }
        this._iWidth = cdSector.readSInt32LE(28);
        if (this._iWidth != 288) {
            return;
        }
        this._iHeight = cdSector.readSInt32LE(32);
        if (this._iHeight != 144) {
            return;
        }
        for (i = VMNK_HEADER.length + 8; i < cdSector.getCdUserDataSize(); ++i) {
            if (cdSector.readUserDataByte(i) == 0) continue;
            return;
        }
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "Policenauts VMNK";
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public String toString() {
        return String.format("%s %s %dx%d", this.getTypeName(), super.toString(), this._iWidth, this._iHeight);
    }
}

