/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.policenauts.SectorPolicenauts;
import jpsxdec.util.Misc;

public class SectorPN_KLBS
extends SectorPolicenauts {
    public static final int SIZEOF_KLBS_HEADER = 32;
    public static final int KLBS_SECTOR_COUNT = 128;
    private int _iSize;
    private int _iEntryCount;

    public SectorPN_KLBS(@Nonnull CdSector cdSector) {
        super(cdSector, false);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (cdSector.readUserDataByte(i) == 0) continue;
            return;
        }
        byte[] abKlbs = new byte[4];
        cdSector.getCdUserDataCopy(8, abKlbs, 0, 4);
        String sKlbs = Misc.asciiToString(abKlbs);
        if (!"KLBS".equals(sKlbs)) {
            return;
        }
        this._iSize = cdSector.readSInt32LE(12);
        if (this._iSize != 262144) {
            return;
        }
        this._iEntryCount = cdSector.readSInt32LE(16);
        if (this._iEntryCount < 1 || this._iEntryCount > 83) {
            return;
        }
        int iEntryCount2 = cdSector.readSInt32LE(20);
        if (iEntryCount2 != this._iEntryCount) {
            return;
        }
        for (int i = 24; i < 32; ++i) {
            if (cdSector.readUserDataByte(i) == 0) continue;
            return;
        }
        this.setProbability(100);
    }

    public int getSectorLength() {
        return 128;
    }

    public int getEndSectorInclusive() {
        return this.getSectorNumber() + 128 - 1;
    }

    public int getEntryCount() {
        return this._iEntryCount;
    }

    @Override
    public String getTypeName() {
        return "Policenauts KLBS";
    }

    @Override
    public String toString() {
        return String.format("%s %s size:%d entries:%d", this.getTypeName(), super.toString(), this._iSize, this._iEntryCount);
    }
}

