/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.policenauts.SPacketData;
import jpsxdec.modules.policenauts.SPacketPos;
import jpsxdec.modules.policenauts.SectorPN_KLBS;
import jpsxdec.modules.policenauts.SectorPN_VMNK;
import jpsxdec.modules.policenauts.SectorPolicenauts;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.IOIterator;
import jpsxdec.util.PushAvailableInputStream;

public class SectorClaimToPolicenauts
implements SectorClaimSystem.SectorClaimer {
    @CheckForNull
    private KlbsSectorRange _currentKlbs;

    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (cs.isClaimed()) {
            this.checkCorruptionIfExistingKlbs(log);
            return;
        }
        SectorPN_VMNK vmnkSector = new SectorPN_VMNK(cs.getSector());
        if (vmnkSector.getProbability() == 100) {
            this.checkCorruptionIfExistingKlbs(log);
            cs.claim(vmnkSector);
        } else {
            SectorPolicenauts pnSector = null;
            SectorPN_KLBS klbsSector = new SectorPN_KLBS(cs.getSector());
            if (klbsSector.getProbability() == 100) {
                this.checkCorruptionIfExistingKlbs(log);
                pnSector = klbsSector;
                this._currentKlbs = new KlbsSectorRange(klbsSector, log);
                cs.claim(klbsSector);
            } else if (this._currentKlbs != null) {
                pnSector = this._currentKlbs.readSector(cs.getSector(), log);
                if (this._currentKlbs._blnAtEnd) {
                    this._currentKlbs = null;
                }
            }
            if (pnSector != null) {
                cs.claim(pnSector);
            }
        }
    }

    private void checkCorruptionIfExistingKlbs(@Nonnull ILocalizedLogger log) {
        if (this._currentKlbs != null) {
            log.log(Level.WARNING, I.POLICENAUTS_DATA_CORRUPTION());
            this._currentKlbs = null;
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
    }

    private static final class KlbsSectorRange {
        @CheckForNull
        private KlbsStreamReader _stream;
        private final int _iKlbsEndSectorInclusive;
        private boolean _blnAtEnd = false;

        public KlbsSectorRange(@Nonnull SectorPN_KLBS klbsSector, @Nonnull ILocalizedLogger log) {
            this._stream = new KlbsStreamReader(klbsSector);
            this._iKlbsEndSectorInclusive = klbsSector.getEndSectorInclusive();
            this.readIntoSector(klbsSector, 32, log);
        }

        @Nonnull
        public SectorPolicenauts readSector(@Nonnull CdSector cdSector, @Nonnull ILocalizedLogger log) {
            if (this._blnAtEnd) {
                throw new AssertionError();
            }
            boolean blnAtEnd = cdSector.getSectorIndexFromStart() >= this._iKlbsEndSectorInclusive;
            SectorPolicenauts pnSector = new SectorPolicenauts(cdSector, blnAtEnd);
            this.readIntoSector(pnSector, 0, log);
            this._blnAtEnd = blnAtEnd;
            return pnSector;
        }

        public void readIntoSector(@Nonnull SectorPolicenauts pnSector, int iSkip, @Nonnull ILocalizedLogger log) {
            if (this._stream == null) {
                return;
            }
            if (this._blnAtEnd) {
                throw new AssertionError();
            }
            try {
                List<SPacketData> finishedPackets = this._stream.readSectorPackets(pnSector, iSkip);
                if (this._stream.allRead()) {
                    this._stream = null;
                }
                pnSector.setPacketsEndingInThisSector(finishedPackets);
            }
            catch (BinaryDataNotRecognized ex) {
                log.log(Level.SEVERE, I.POLICENAUTS_DATA_CORRUPTION(), ex);
                this._stream = null;
            }
        }
    }

    private static class KlbsStreamReader {
        private static final int READ_HEADER = 1;
        private static final int READ_PACKET = 2;
        private static final int DONE = 3;
        private final int _iEntryCount;
        private final int _iKlbsStartSector;
        private final int _iKlbsEndSectorInclusive;
        @Nonnull
        private final PushAvailableInputStream<SectorPolicenauts> _sectorStream = new PushAvailableInputStream();
        private List<SPacketPos> _sPackets;
        private int _iNextRequiredBytes = 0;
        private int _iState = 1;
        private int _iPacketDataRead = 0;

        public KlbsStreamReader(@Nonnull SectorPN_KLBS klbsSector) {
            this._iEntryCount = klbsSector.getEntryCount();
            this._iKlbsStartSector = klbsSector.getSectorNumber();
            this._iKlbsEndSectorInclusive = klbsSector.getEndSectorInclusive();
            this._iNextRequiredBytes = this._iEntryCount * 48;
        }

        public boolean allRead() {
            return this._iState == 3;
        }

        public List<SPacketData> readSectorPackets(@Nonnull SectorPolicenauts sector, int iSkip) throws BinaryDataNotRecognized {
            try {
                ByteArrayFPIS is = sector.getCdSector().getCdUserDataStream();
                if (iSkip > 0) {
                    is.skip(iSkip);
                }
                this._sectorStream.addStream(is, sector);
                return this.doReadAllAvailablePackets(sector);
            }
            catch (IOException ex) {
                throw new RuntimeException("Should not happen", ex);
            }
        }

        @Nonnull
        private List<SPacketData> doReadAllAvailablePackets(@Nonnull SectorPolicenauts sector) throws BinaryDataNotRecognized, IOException {
            ArrayList<SPacketData> finishedPackets = null;
            while (this._sectorStream.available() >= this._iNextRequiredBytes && this._iState != 3) {
                switch (this._iState) {
                    case 1: {
                        this._sPackets = SPacketPos.readPackets(this._sectorStream, this._iEntryCount, this._iKlbsStartSector, this._iKlbsEndSectorInclusive);
                        this._iNextRequiredBytes = this._sPackets.get(0).getSize();
                        this._iState = 2;
                        break;
                    }
                    case 2: {
                        SPacketPos packetPos = this._sPackets.get(this._iPacketDataRead);
                        this.skipZeroes(packetPos.getPaddingBeforeThisPacket());
                        SPacketData packetData = packetPos.read(this._sectorStream);
                        assert (this._sectorStream.getCurrentMeta() == sector);
                        if (finishedPackets == null) {
                            finishedPackets = new ArrayList<SPacketData>(3);
                        }
                        finishedPackets.add(packetData);
                        ++this._iPacketDataRead;
                        if (this._iPacketDataRead >= this._sPackets.size()) {
                            this._iState = 3;
                            break;
                        }
                        SPacketPos nextPacket = this._sPackets.get(this._iPacketDataRead);
                        this._iNextRequiredBytes = nextPacket.getPaddingBeforeThisPacket() + nextPacket.getSize();
                    }
                }
            }
            if (finishedPackets == null) {
                return Collections.emptyList();
            }
            return finishedPackets;
        }

        private void skipZeroes(int iCount) throws IOException, BinaryDataNotRecognized {
            while (iCount > 0) {
                int iByte = this._sectorStream.read();
                if (iByte != 0) {
                    throw new BinaryDataNotRecognized("Expected 0 in sector %s but got %d", this._sectorStream.getCurrentMeta(), iByte);
                }
                --iCount;
            }
        }
    }
}

