/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.modules.policenauts.SPacket;
import jpsxdec.modules.policenauts.SPacketData;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;

public class SPacketPos {
    private static final Logger LOG = Logger.getLogger(SPacketPos.class.getName());
    @Nonnull
    private final SPacket _sPacket;
    private final int _iKlbsStartSectorNum;
    private final int _iKlbsEndSectorNumInclusive;
    private final int _iIndexInKlbs;
    private final int _iStartSector;
    private final int _iStartSectorOfs;
    private int _iCorrectedSize;
    private int _iPaddingBeforeThisPacket = 0;
    private int _iPaddingAfterThisPacket = 0;

    @Nonnull
    public static List<SPacketPos> readPackets(@Nonnull InputStream is, int iEntryCount, int iKlbsStartSector, int iKlbsEndSectorInclusive) throws IOException, BinaryDataNotRecognized {
        ArrayList<SPacketPos> _sPackets = new ArrayList<SPacketPos>();
        for (int i = 0; i < iEntryCount; ++i) {
            SPacket packet = new SPacket(is);
            SPacketPos packetPos = new SPacketPos(packet, iKlbsStartSector, iKlbsEndSectorInclusive, i);
            if (i > 0) {
                SPacketPos prev = _sPackets.get(i - 1);
                prev.checkAgainstNextPacket(packetPos);
            }
            _sPackets.add(packetPos);
        }
        return _sPackets;
    }

    public SPacketPos(@Nonnull SPacket sPacket, int iKlbsStartSectorNum, int iKlbsEndSectorNumInclusive, int iIndexInKlbs) {
        this._sPacket = sPacket;
        this._iKlbsStartSectorNum = iKlbsStartSectorNum;
        this._iKlbsEndSectorNumInclusive = iKlbsEndSectorNumInclusive;
        this._iIndexInKlbs = iIndexInKlbs;
        this._iStartSector = iKlbsStartSectorNum + sPacket.getOffset() / 2048;
        this._iStartSectorOfs = sPacket.getOffset() % 2048;
        this._iCorrectedSize = sPacket.getSize();
    }

    public int getSize() {
        return this._iCorrectedSize;
    }

    public int getPaddingBeforeThisPacket() {
        return this._iPaddingBeforeThisPacket;
    }

    public int getTimestamp() {
        return this._sPacket.getTimestamp();
    }

    public int getDuration() {
        return this._sPacket.getDuration();
    }

    public boolean isVideo() {
        return this._sPacket.getType() == SPacket.Type.SCIPPDTS;
    }

    public boolean isAudio() {
        return this._sPacket.getType() == SPacket.Type.SDNSSDTS;
    }

    public int getKlbsStartSectorNum() {
        return this._iKlbsStartSectorNum;
    }

    public int getKlbsEndSectorNum() {
        return this._iKlbsEndSectorNumInclusive;
    }

    public void checkAgainstNextPacket(@Nonnull SPacketPos nextPacket) throws BinaryDataNotRecognized {
        if (nextPacket.getPacket().getOffset() < this._sPacket.getOffset()) {
            throw new BinaryDataNotRecognized();
        }
        if (nextPacket.getPacket().getTimestamp() < this._sPacket.getTimestamp()) {
            LOG.log(Level.INFO, "{0} < {1}", new Object[]{nextPacket, this._sPacket});
            if (nextPacket.getPacket().getTimestamp() + 15 < this._sPacket.getTimestamp()) {
                throw new BinaryDataNotRecognized("Next packet timestamp %i < current packet timestamp %i", nextPacket.getPacket().getTimestamp(), this._sPacket.getTimestamp());
            }
        }
        int iBytesBetweenPacketStarts = nextPacket._sPacket.getOffset() - this._sPacket.getOffset();
        if (this._sPacket.getSize() > iBytesBetweenPacketStarts) {
            LOG.log(Level.WARNING, "{0} packet size exceeds room {1,number,#} (expected for MV000003.MOV on disc 2)", new Object[]{this, iBytesBetweenPacketStarts});
            if (this.isAudio() && iBytesBetweenPacketStarts % 16 != 0) {
                throw new BinaryDataNotRecognized();
            }
            this._iCorrectedSize = iBytesBetweenPacketStarts;
        }
        nextPacket._iPaddingBeforeThisPacket = this._iPaddingAfterThisPacket = iBytesBetweenPacketStarts - this._iCorrectedSize;
    }

    @Nonnull
    public SPacketData read(@Nonnull InputStream is) throws EOFException, IOException {
        byte[] abData = IO.readByteArray(is, this._iCorrectedSize);
        return new SPacketData(this, abData);
    }

    public int getStartSector() {
        return this._iStartSector;
    }

    public int getEndSectorInclusive() {
        int iSector = this._iStartSector + (this._iStartSectorOfs + this._iCorrectedSize) / 2048;
        assert (iSector == this._iKlbsStartSectorNum + (this._sPacket.getOffset() + this._iCorrectedSize) / 2048);
        if ((this._iStartSectorOfs + this._iCorrectedSize) % 2048 == 0) {
            return iSector - 1;
        }
        return iSector;
    }

    public int bytesToThisPacket(int iFromSector, int iFromSectorOffset) {
        int iSectorDiff = this._iStartSector - iFromSector;
        int iOfsDiff = this._iStartSectorOfs - iFromSectorOffset;
        int i = iSectorDiff * 2048 + iOfsDiff;
        return i;
    }

    @Nonnull
    public SPacket getPacket() {
        return this._sPacket;
    }

    public String toString() {
        return String.format("Start %d [%d] sector.ofs %d.%d %s", this._iKlbsStartSectorNum, this._iIndexInKlbs, this._iStartSector, this._iStartSectorOfs, this._sPacket);
    }
}

