/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.modules.policenauts.SPacketPos;

public class SPacketData {
    @Nonnull
    private final SPacketPos _sPacketPos;
    @Nonnull
    private final byte[] _abData;

    public SPacketData(@Nonnull SPacketPos sPacketPos, @Nonnull byte[] abData) {
        this._sPacketPos = sPacketPos;
        this._abData = abData;
    }

    public boolean isAudio() {
        return this._sPacketPos.isAudio();
    }

    public boolean isVideo() {
        return this._sPacketPos.isVideo();
    }

    @Nonnull
    public byte[] getData() {
        return this._abData;
    }

    public int getSoundUnitCount() {
        return this._abData.length / 16;
    }

    public void decodeAudio(@Nonnull SpuAdpcmDecoder.Mono decoder, @Nonnull OutputStream pcmOut) {
        ByteArrayInputStream spuIn = new ByteArrayInputStream(this._abData);
        try {
            decoder.decode(spuIn, this.getSoundUnitCount(), pcmOut);
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    public int getKlbsStartSectorNum() {
        return this._sPacketPos.getKlbsStartSectorNum();
    }

    public int getKlbsEndSectorNum() {
        return this._sPacketPos.getKlbsEndSectorNum();
    }

    public int getStartSector() {
        return this._sPacketPos.getStartSector();
    }

    public int getEndSectorInclusive() {
        return this._sPacketPos.getEndSectorInclusive();
    }

    public int getTimestamp() {
        return this._sPacketPos.getTimestamp();
    }

    public int getDuration() {
        return this._sPacketPos.getDuration();
    }

    public String toString() {
        return this._sPacketPos.toString();
    }
}

