/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.Fraction;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class SPacket {
    public static final int AUDIO_SAMPLE_FRAMES_PER_SECOND = 44100;
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 1, true, false);
    public static final Fraction AUDIO_SAMPLE_FRAMES_PER_TIMESTAMP = new Fraction(28672L, 156L);
    public static final Fraction TIMESTAMP_UNITS_PER_SECOND = Fraction.divide(44100L, AUDIO_SAMPLE_FRAMES_PER_TIMESTAMP);
    public static final Fraction SECONDS_PER_TIMESTAMP = Fraction.divide(1L, TIMESTAMP_UNITS_PER_SECOND);
    public static final int TIMESTAMP_UNITS_PER_FRAME = 20;
    public static final Fraction FRAMES_PER_SECOND = TIMESTAMP_UNITS_PER_SECOND.divide(20L);
    public static final Fraction SECTORS150_PER_FRAME = Fraction.divide(150L, FRAMES_PER_SECOND);
    public static final Fraction SECTORS150_PER_TIMESTAMP = SECONDS_PER_TIMESTAMP.multiply(150L);
    public static final int SIZEOF = 48;
    @Nonnull
    private final Type _type;
    private final int _iTimestamp;
    private final int _iDuration;
    private final int _iOffset;
    private final int _iSize;

    public SPacket(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        long lng8Zeroes = IO.readSInt64BE(is);
        if (lng8Zeroes != 0L) {
            throw new BinaryDataNotRecognized();
        }
        byte[] abTag = new byte[8];
        IO.readByteArray(is, abTag);
        try {
            this._type = Type.valueOf(Misc.asciiToString(abTag));
        }
        catch (IllegalArgumentException ex) {
            throw new BinaryDataNotRecognized(ex);
        }
        this._iTimestamp = IO.readSInt32LE(is);
        if (this._iTimestamp < 0 || this._iTimestamp > 63780) {
            throw new BinaryDataNotRecognized();
        }
        this._iDuration = IO.readSInt32LE(is);
        if (this._iDuration < 0 || this._iDuration > 156) {
            throw new BinaryDataNotRecognized();
        }
        this._iOffset = IO.readSInt32LE(is);
        if (this._iOffset < 1) {
            throw new BinaryDataNotRecognized();
        }
        this._iSize = IO.readSInt32LE(is);
        if (this._iSize < 5 || this._iSize > 17000) {
            throw new BinaryDataNotRecognized();
        }
        lng8Zeroes = IO.readSInt64BE(is);
        if (lng8Zeroes != 0L) {
            throw new BinaryDataNotRecognized();
        }
        lng8Zeroes = IO.readSInt64BE(is);
        if (lng8Zeroes != 0L) {
            throw new BinaryDataNotRecognized();
        }
        if (this._type == Type.SDNSSDTS && this._iSize % 16 != 0) {
            throw new BinaryDataNotRecognized();
        }
    }

    @Nonnull
    public Type getType() {
        return this._type;
    }

    public int getTimestamp() {
        return this._iTimestamp;
    }

    public int getDuration() {
        return this._iDuration;
    }

    public int getOffset() {
        return this._iOffset;
    }

    public int getSize() {
        return this._iSize;
    }

    public String toString() {
        return String.format("%s Time:%d Duration:%d Offset:%d Size:%d", new Object[]{this._type, this._iTimestamp, this._iDuration, this._iOffset, this._iSize});
    }

    public static enum Type {
        SDNSSDTS("SDNSSDTS (audio)"),
        SCIPPDTS("SCIPPDTS (video)"),
        SDNSHDTS,
        SCTELLEC,
        SCTEGOLD,
        SCTEGLEC,
        SCTEMLEC;

        @CheckForNull
        private final String _sToString;

        private Type() {
            this._sToString = null;
        }

        private Type(String sToString) {
            this._sToString = sToString;
        }

        public String toString() {
            return this._sToString == null ? super.toString() : this._sToString;
        }
    }
}

