/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.policenauts.SPacketData;
import jpsxdec.modules.policenauts.SectorPN_VMNK;
import jpsxdec.modules.policenauts.SectorPolicenauts;

public class PolicenautsSectorToPacket
implements IdentifiedSectorListener<SectorPolicenauts> {
    private final ArrayList<Listener> _listeners = new ArrayList();

    public static void attachToSectorClaimer(@Nonnull SectorClaimSystem scs, @Nonnull Listener listener) {
        PolicenautsSectorToPacket thisListener = scs.getIdListener(PolicenautsSectorToPacket.class);
        if (thisListener == null) {
            thisListener = new PolicenautsSectorToPacket(listener);
            thisListener.addListener(listener);
            scs.addIdListener(thisListener);
        } else {
            thisListener.addListener(listener);
        }
    }

    private PolicenautsSectorToPacket(@Nonnull Listener listener) {
        this.addListener(listener);
    }

    private void addListener(@Nonnull Listener newListener) {
        for (Listener listener : this._listeners) {
            if (listener != newListener) continue;
            return;
        }
        this._listeners.add(newListener);
    }

    @Override
    @Nonnull
    public Class<SectorPolicenauts> getListeningFor() {
        return SectorPolicenauts.class;
    }

    @Override
    public void feedSector(@Nonnull SectorPolicenauts pnSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (pnSector instanceof SectorPN_VMNK) {
            SectorPN_VMNK vmnk = (SectorPN_VMNK)pnSector;
            for (Listener listener : this._listeners) {
                listener.videoStart(vmnk.getWidth(), vmnk.getHeight(), log);
            }
        }
        for (SPacketData sPacketData : pnSector) {
            for (Listener listener : this._listeners) {
                listener.feedPacket(sPacketData, log);
            }
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        for (Listener listener : this._listeners) {
            listener.endOfSectors(log);
        }
    }

    public static interface Listener {
        public void videoStart(int var1, int var2, @Nonnull ILocalizedLogger var3);

        public void feedPacket(@Nonnull SPacketData var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void endOfSectors(@Nonnull ILocalizedLogger var1);
    }
}

