/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.policenauts.DemuxedPolicenautsFrame;
import jpsxdec.modules.policenauts.PolicenautsSectorToPacket;
import jpsxdec.modules.policenauts.SPacket;
import jpsxdec.modules.policenauts.SPacketData;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.packetbased.DiscItemPacketBasedVideoStream;
import jpsxdec.modules.video.packetbased.SectorClaimToAudioAndFrame;
import jpsxdec.util.Fraction;

public class DiscItemPolicenauts
extends DiscItemPacketBasedVideoStream {
    public static final String TYPE_ID = "Policenauts";
    @Nonnull
    private final HeaderFrameNumber.Format _timestampFrameNumberFormat;

    public DiscItemPolicenauts(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format sectorIndexFrameNumberFormat, @Nonnull HeaderFrameNumber.Format timestampFrameNumberFormat, int iSoundUnitCount) {
        super(cd, iStartSector, iEndSector, dim, sectorIndexFrameNumberFormat, iSoundUnitCount);
        this._timestampFrameNumberFormat = timestampFrameNumberFormat;
    }

    public DiscItemPolicenauts(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._timestampFrameNumberFormat = new HeaderFrameNumber.Format(fields);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._timestampFrameNumberFormat.serialize(serial);
        return serial;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return false;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        return this._timestampFrameNumberFormat.getStartFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    public FrameNumber getEndFrame() {
        return this._timestampFrameNumberFormat.getEndFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Header, FrameNumber.Type.Sector);
    }

    @Override
    protected double getPacketBasedFpsInterestingDescription() {
        return SPacket.FRAMES_PER_SECOND.asDouble();
    }

    @Override
    @Nonnull
    public Fraction getSectorsPerFrame() {
        return SPacket.SECTORS150_PER_FRAME;
    }

    @Override
    public double getApproxDuration() {
        return (double)this.getFrameCount() / SPacket.FRAMES_PER_SECOND.asDouble();
    }

    @Override
    public int getAudioSampleFramesPerSecond() {
        return 44100;
    }

    @Override
    @Nonnull
    public SectorClaimToAudioAndFrame makeAudioVideoDemuxer(double dblVolume) {
        return new Demuxer(this.getWidth(), this.getHeight(), this.getStartSector(), dblVolume, this._timestampFrameNumberFormat.makeFormatter(this._indexSectorFrameNumberFormat));
    }

    public class Demuxer
    extends SectorClaimToAudioAndFrame
    implements PolicenautsSectorToPacket.Listener {
        private final int _iWidth;
        private final int _iHeight;
        @Nonnull
        private final IFrameNumberFormatterWithHeader _fnf;
        private final int _iStartSector;
        @CheckForNull
        private IDemuxedFrame.Listener _frameListener;
        @CheckForNull
        private DecodedAudioPacket.Listener _audioListener;
        @Nonnull
        private final SpuAdpcmDecoder.Mono _audioDecoder;
        private Fraction _zeroTimestampOffset = Fraction.ZERO;
        private boolean _blnPrevTimestampWas0 = false;
        private int _iPrevDuration = 0;
        private final SectorRange _sectorRange = DiscItemPolicenauts.this.makeSectorRange();
        private final ByteArrayOutputStream _pcmOut = new ByteArrayOutputStream();

        public Demuxer(int iWidth, int iHeight, int iStartSector, @Nonnull double dblVolume, IFrameNumberFormatterWithHeader fnf) {
            this._iWidth = iWidth;
            this._iHeight = iHeight;
            this._iStartSector = iStartSector;
            this._audioDecoder = new SpuAdpcmDecoder.Mono(dblVolume);
            this._fnf = fnf;
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            PolicenautsSectorToPacket.attachToSectorClaimer(scs, this);
        }

        @Override
        public void videoStart(int iWidth, int iHeight, @Nonnull ILocalizedLogger log) {
            if (iWidth != DiscItemPolicenauts.this.getWidth() || iHeight != DiscItemPolicenauts.this.getHeight()) {
                throw new RuntimeException("Somehow the dimensions do not match. Maybe the index was edited?");
            }
        }

        @Override
        public void feedPacket(@Nonnull SPacketData packet, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            if (!this._sectorRange.sectorIsInRange(packet.getStartSector()) || !this._sectorRange.sectorIsInRange(packet.getEndSectorInclusive())) {
                return;
            }
            if (packet.isAudio()) {
                if (this._audioListener != null) {
                    this._pcmOut.reset();
                    if (this._blnPrevTimestampWas0 && packet.getTimestamp() == 0) {
                        this._zeroTimestampOffset = this._zeroTimestampOffset.add(SPacket.SECTORS150_PER_TIMESTAMP.multiply(this._iPrevDuration));
                    }
                    Fraction close = SPacket.SECTORS150_PER_TIMESTAMP.multiply(packet.getTimestamp()).add(this._iStartSector).add(this._zeroTimestampOffset);
                    this._blnPrevTimestampWas0 = packet.getTimestamp() == 0;
                    this._iPrevDuration = packet.getDuration();
                    packet.decodeAudio(this._audioDecoder, this._pcmOut);
                    DecodedAudioPacket aup = new DecodedAudioPacket(0, SPacket.AUDIO_FORMAT, close, this._pcmOut.toByteArray());
                    this._audioListener.audioPacketComplete(aup, log);
                }
            } else if (packet.isVideo()) {
                FrameNumber fn = this._fnf.next(packet.getStartSector(), packet.getTimestamp(), log);
                if (this._frameListener != null) {
                    this._frameListener.frameComplete(new DemuxedPolicenautsFrame(this._iWidth, this._iHeight, packet, fn, SPacket.SECTORS150_PER_TIMESTAMP.multiply(packet.getTimestamp()).add(this._iStartSector)));
                }
            }
        }

        @Override
        public void endOfSectors(ILocalizedLogger log) {
        }

        @Override
        public void setFrameListener(@CheckForNull IDemuxedFrame.Listener listener) {
            this._frameListener = listener;
        }

        @Override
        public void setAudioListener(@Nonnull DecodedAudioPacket.Listener listener) {
            this._audioListener = listener;
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat() {
            return SPacket.AUDIO_FORMAT;
        }

        @Override
        public double getVolume() {
            return this._audioDecoder.getVolume();
        }

        @Override
        public int getAbsolutePresentationStartSector() {
            return DiscItemPolicenauts.this.getStartSector();
        }

        @Override
        public int getStartSector() {
            return DiscItemPolicenauts.this.getStartSector();
        }

        @Override
        public int getEndSector() {
            return DiscItemPolicenauts.this.getEndSector();
        }

        @Override
        public int getSampleFramesPerSecond() {
            return 44100;
        }

        @Override
        public int getDiscSpeed() {
            return 2;
        }
    }
}

