/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.policenauts;

import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.policenauts.DiscItemPolicenauts;
import jpsxdec.modules.policenauts.PolicenautsSectorToPacket;
import jpsxdec.modules.policenauts.SPacketData;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;

public class DiscIndexerPolicenauts
extends DiscIndexer
implements PolicenautsSectorToPacket.Listener {
    @CheckForNull
    private VidBuilder _currentVid;
    @CheckForNull
    private Dimensions _dims;

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        PolicenautsSectorToPacket.attachToSectorClaimer(scs, this);
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("Policenauts".equals(fields.getType())) {
            return new DiscItemPolicenauts(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void videoStart(int iWidth, int iHeight, @Nonnull ILocalizedLogger log) {
        if (this._currentVid != null) {
            this._currentVid.finishVid(log);
            this._currentVid = null;
        }
        this._dims = new Dimensions(iWidth, iHeight);
    }

    @Override
    public void feedPacket(@Nonnull SPacketData packet, @Nonnull ILocalizedLogger log) {
        if (this._dims == null) {
            log.log(Level.WARNING, I.POLICENAUTS_DATA_CORRUPTION());
            return;
        }
        if (this._currentVid == null) {
            this._currentVid = new VidBuilder(packet, this._dims);
        } else {
            this._currentVid.addPacket(packet);
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
        if (this._currentVid != null) {
            this._currentVid.finishVid(log);
            this._currentVid = null;
            this._dims = null;
        }
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    private class VidBuilder {
        @Nonnull
        private final Dimensions __dims;
        private final int __iStartKlbsStartSector;
        private int __iLastKlbsEndSector;
        @CheckForNull
        private IndexSectorFrameNumber.Format.Builder __indexSectorFrameNumberBuilder;
        @CheckForNull
        private HeaderFrameNumber.Format.Builder __headerFrameNumberBuilder;
        private int __iSoundUnitCount = 0;

        public VidBuilder(SPacketData firstPacket, Dimensions dims) {
            this.__dims = dims;
            this.__iStartKlbsStartSector = firstPacket.getKlbsStartSectorNum();
            this.__iLastKlbsEndSector = firstPacket.getKlbsEndSectorNum();
            this.addPacket(firstPacket);
        }

        public final void addPacket(@Nonnull SPacketData packet) {
            this.__iLastKlbsEndSector = packet.getKlbsEndSectorNum();
            if (packet.isAudio()) {
                this.__iSoundUnitCount += packet.getSoundUnitCount();
            } else if (packet.isVideo()) {
                if (this.__headerFrameNumberBuilder == null) {
                    this.__headerFrameNumberBuilder = new HeaderFrameNumber.Format.Builder(packet.getTimestamp());
                } else {
                    this.__headerFrameNumberBuilder.addHeaderFrameNumber(packet.getTimestamp());
                }
                if (this.__indexSectorFrameNumberBuilder == null) {
                    this.__indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(packet.getStartSector());
                } else {
                    this.__indexSectorFrameNumberBuilder.addFrameStartSector(packet.getStartSector());
                }
            }
        }

        public void finishVid(ILocalizedLogger log) {
            if (this.__indexSectorFrameNumberBuilder == null) {
                log.log(Level.WARNING, I.POLICENAUTS_DATA_CORRUPTION());
                return;
            }
            DiscItemPolicenauts di = new DiscItemPolicenauts(DiscIndexerPolicenauts.this.getCd(), this.__iStartKlbsStartSector, this.__iLastKlbsEndSector, this.__dims, this.__indexSectorFrameNumberBuilder.makeFormat(), this.__headerFrameNumberBuilder.makeFormat(), this.__iSoundUnitCount);
            DiscIndexerPolicenauts.this.addDiscItem(di);
        }
    }
}

