/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.player;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.player.AudioPlayerSectorTimedWriter;
import jpsxdec.modules.player.WrapIOException;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.save.AutowireVDP;
import jpsxdec.modules.video.save.Frame2Bitstream;
import jpsxdec.modules.video.save.VDP;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecDecoder_int;
import jpsxdec.psxvideo.mdec.idct.SimpleIDCT;
import jpsxdec.util.Fraction;
import jpsxdec.util.player.IFrameProcessor;
import jpsxdec.util.player.IMediaDataReader;
import jpsxdec.util.player.IPreprocessedFrameWriter;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.StopPlayingException;

public class MediaPlayer
implements IMediaDataReader {
    private final int _iMovieStartSector;
    private final int _iMovieEndSector;
    @Nonnull
    private final CdFileSectorReader _cdReader;
    @Nonnull
    private final PlayController _controller;
    private final AutowireVDP _demuxAutowire = new AutowireVDP();
    private final AutowireVDP _decodeAutowire = new AutowireVDP();
    private final int _iSectorsPerSecond;

    public MediaPlayer(@Nonnull DiscItemVideoStream vid, @Nonnull ISectorClaimToDemuxedFrame demuxer) {
        this(vid, demuxer, vid.getStartSector(), vid.getEndSector());
    }

    public MediaPlayer(@Nonnull DiscItemVideoStream vid, @Nonnull ISectorClaimToDemuxedFrame demuxer, int iSectorStart, int iSectorEnd) {
        this(vid, demuxer, null, iSectorStart, iSectorEnd);
    }

    public MediaPlayer(@Nonnull DiscItemAudioStream aud) {
        this._cdReader = aud.getSourceCd();
        this._iMovieStartSector = aud.getStartSector();
        this._iMovieEndSector = aud.getEndSector();
        this._iSectorsPerSecond = aud.getDiscSpeed() == 1 ? 75 : 150;
        ISectorAudioDecoder audioDecoder = aud.makeDecoder(1.0);
        this._demuxAutowire.setAudioDecoder(audioDecoder);
        this._controller = new PlayController(audioDecoder.getOutputFormat());
        this._controller.setReader(this);
        audioDecoder.getAbsolutePresentationStartSector();
        AudioPlayerSectorTimedWriter audioWriter = new AudioPlayerSectorTimedWriter(this._controller.getAudioOutputStream(), this._iMovieStartSector, this._iSectorsPerSecond, audioDecoder.getSampleFramesPerSecond());
        this._demuxAutowire.setAudioPacketListener(audioWriter);
    }

    public MediaPlayer(@Nonnull DiscItemVideoStream vid, @Nonnull ISectorClaimToDemuxedFrame demuxer, @Nonnull ISectorAudioDecoder audioDecoder, int iSectorStart, int iSectorEnd) {
        this._cdReader = vid.getSourceCd();
        this._iMovieStartSector = iSectorStart;
        this._iMovieEndSector = iSectorEnd;
        this._iSectorsPerSecond = vid.getDiscSpeed() == 1 ? 75 : 150;
        this._demuxAutowire.setMap(demuxer);
        if (audioDecoder == null) {
            this._controller = new PlayController(vid.getWidth(), vid.getHeight());
        } else {
            this._controller = new PlayController(vid.getWidth(), vid.getHeight(), audioDecoder.getOutputFormat());
            AudioPlayerSectorTimedWriter audioWriter = new AudioPlayerSectorTimedWriter(this._controller.getAudioOutputStream(), this._iMovieStartSector, this._iSectorsPerSecond, audioDecoder.getSampleFramesPerSecond());
            this._demuxAutowire.setAudioDecoder(audioDecoder);
            this._demuxAutowire.setAudioPacketListener(audioWriter);
        }
        ProcessingThread pt = new ProcessingThread(vid.getWidth(), vid.getHeight());
        this._controller.setVidProcressor(pt);
        this._decodeAutowire.setMap(pt);
        this._decodeAutowire.setDecodedListener(pt);
        this._decodeAutowire.setMap(new VDP.Mdec2Decoded(new MdecDecoder_int(new SimpleIDCT(), vid.getWidth(), vid.getHeight()), DebugLogger.Log));
        this._decodeAutowire.setMap(new VDP.Bitstream2Mdec());
        this._decodeAutowire.autowire();
        vid.getAbsolutePresentationStartSector();
        this._demuxAutowire.setFrameListener(new DemuxFrameToPlayerProcessor(this._controller.getFrameWriter(), this._iMovieStartSector, this._iSectorsPerSecond));
        this._controller.setReader(this);
    }

    @Override
    public void demuxThread(@Nonnull PlayController controller) throws StopPlayingException {
        try {
            int iSectorLength = this._iMovieEndSector - this._iMovieStartSector + 1;
            SectorClaimSystem it = SectorClaimSystem.create(this._cdReader, this._iMovieStartSector, this._iMovieEndSector);
            this._demuxAutowire.attachToSectorClaimer(it);
            this._demuxAutowire.autowire();
            int iSector = 0;
            while (it.hasNext() && !controller.isClosed()) {
                IIdentifiedSector identifiedSector = it.next(DebugLogger.Log);
                ++iSector;
            }
            it.close(DebugLogger.Log);
        }
        catch (WrapIOException ex) {
            if (ex.getCause() instanceof StopPlayingException) {
                throw (StopPlayingException)ex.getCause();
            }
            throw new StopPlayingException(ex.getCause());
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new StopPlayingException(ex);
        }
    }

    @Nonnull
    public PlayController getPlayController() {
        return this._controller;
    }

    private static class ProcessingThread
    extends Frame2Bitstream
    implements IFrameProcessor<IDemuxedFrame>,
    VDP.IDecodedListener {
        private final int _iWidth;
        private final int _iHeight;
        private int[] _aiDrawHere;

        public ProcessingThread(int iWidth, int iHeight) {
            super(FrameNumber.Type.Index);
            this._iWidth = iWidth;
            this._iHeight = iHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processFrame(@Nonnull IDemuxedFrame frame, int[] drawHere) {
            this._aiDrawHere = drawHere;
            try {
                this.frameComplete(frame);
            }
            catch (LoggedFailure ex) {
                System.err.println("Frame " + frame.getFrame() + " " + ex.getMessage());
            }
            finally {
                this._aiDrawHere = null;
            }
        }

        @Override
        public void decoded(@Nonnull MdecDecoder decoder, FormattedFrameNumber _ignoredFN, Fraction _ignoredPS) {
            decoder.readDecodedRgb(this._iWidth, this._iHeight, this._aiDrawHere);
        }

        @Override
        public void error(ILocalizedMessage errMsg, FormattedFrameNumber frameNumber, Fraction presentationSector) {
            System.err.println(errMsg.getEnglishMessage());
        }

        @Override
        public void assertAcceptsDecoded(MdecDecoder decoder) {
        }
    }

    private static class DemuxFrameToPlayerProcessor
    implements IDemuxedFrame.Listener {
        @Nonnull
        private final IPreprocessedFrameWriter _processor;
        private final int _iAbsolutePresentationStartSector;
        private final int _iSectorsPerSecond;

        public DemuxFrameToPlayerProcessor(@Nonnull IPreprocessedFrameWriter processor, int iAbsolutePresentationStartSector, int iSectorsPerSecond) {
            this._processor = processor;
            this._iAbsolutePresentationStartSector = iAbsolutePresentationStartSector;
            this._iSectorsPerSecond = iSectorsPerSecond;
        }

        @Override
        public void frameComplete(@Nonnull IDemuxedFrame frame) {
            long lngPresentationNanos = (long)((frame.getPresentationSector().asDouble() - (double)this._iAbsolutePresentationStartSector) / (double)this._iSectorsPerSecond * 1.0E9);
            try {
                this._processor.writeFrame(frame, lngPresentationNanos);
            }
            catch (StopPlayingException ex) {
                throw new WrapIOException(ex);
            }
        }
    }
}

