/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.player;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.player.WrapIOException;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.video.save.AudioSync;
import jpsxdec.util.IO;

public class AudioPlayerSectorTimedWriter
implements DecodedAudioPacket.Listener {
    @Nonnull
    private final OutputStream _audioOut;
    @Nonnull
    private final AudioSync _audioSync;
    private long _lngSampleFramesWritten = 0L;

    public AudioPlayerSectorTimedWriter(@Nonnull OutputStream audioOutputStream, int iMovieStartSector, int iSectorsPerSecond, int iSamplesPerSecond) {
        this._audioOut = audioOutputStream;
        this._audioSync = new AudioSync(iMovieStartSector, iSectorsPerSecond, iSamplesPerSecond);
    }

    @Override
    public void audioPacketComplete(@Nonnull DecodedAudioPacket packet, @Nonnull ILocalizedLogger log) {
        try {
            long lngSampleFrameDiff = this._audioSync.calculateAudioToCatchUp(packet.getPresentationSector(), this._lngSampleFramesWritten);
            if (lngSampleFrameDiff > 0L) {
                int iToWrite;
                System.out.println("Audio out of sync " + lngSampleFrameDiff + " samples, adding silence.");
                for (long lngSilentBytes = lngSampleFrameDiff * (long)packet.getAudioFormat().getFrameSize(); lngSilentBytes > 0L; lngSilentBytes -= (long)iToWrite) {
                    iToWrite = (int)Math.min(Integer.MAX_VALUE, lngSilentBytes);
                    IO.writeZeros(this._audioOut, iToWrite);
                }
                this._lngSampleFramesWritten += lngSampleFrameDiff;
            }
            this._lngSampleFramesWritten += (long)packet.getSampleFrameCount();
            byte[] abData = packet.getData();
            this._audioOut.write(abData);
        }
        catch (IOException ex) {
            throw new WrapIOException(ex);
        }
    }
}

