/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.panekit;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.modules.panekit.PanekitIkiObfuscation;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_Iki;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

public class BitStreamUncompressor_Panekit
extends BitStreamUncompressor_Iki {
    private static final Logger LOG = Logger.getLogger(BitStreamUncompressor_Panekit.class.getName());

    @CheckForNull
    public static PanekitHeader makePanekitHeader(@Nonnull byte[] abFrameData, int iDataSize) {
        byte[] abQscaleDcLookupTable;
        if (iDataSize < 32) {
            return null;
        }
        int iMdecCodeCount = IO.readSInt16LE(abFrameData, 0);
        int iMagic3800 = IO.readSInt16LE(abFrameData, 2);
        short iCompressedDataSize = IO.readSInt16LE(abFrameData, 4);
        short iWidth = IO.readSInt16LE(abFrameData, 8);
        short iHeight = IO.readSInt16LE(abFrameData, 10);
        if ((iMdecCodeCount ^= 0xFFFFFFFF) < 0 || (iMagic3800 ^= 0xFFFFFFFF) != 14336 || iWidth < 1 || iHeight < 1 || iCompressedDataSize < 1) {
            return null;
        }
        if (iDataSize < 10 + iCompressedDataSize) {
            LOG.log(Level.WARNING, "Incomplete Panekit frame header");
            return null;
        }
        int iBlockCount = Calc.blocks(iWidth, iHeight);
        int iQscaleDcLookupTableSize = iBlockCount * 2;
        byte[] abDeobfuscatedHeader = Arrays.copyOf(abFrameData, 10 + iCompressedDataSize);
        PanekitIkiObfuscation.deobfuscate(abDeobfuscatedHeader);
        try {
            abQscaleDcLookupTable = BitStreamUncompressor_Panekit.ikiLzssUncompress(abDeobfuscatedHeader, 10, iQscaleDcLookupTableSize);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        return new PanekitHeader(iMdecCodeCount, iWidth, iHeight, iCompressedDataSize, iBlockCount, abQscaleDcLookupTable);
    }

    @Nonnull
    public static BitStreamUncompressor_Panekit makePanekit(@Nonnull byte[] abFrameData) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_Panekit.makePanekit(abFrameData, abFrameData.length);
    }

    @Nonnull
    public static BitStreamUncompressor_Panekit makePanekit(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_Panekit bsu = BitStreamUncompressor_Panekit.makePanekitNoThrow(abFrameData, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    public static BitStreamUncompressor_Panekit makePanekitNoThrow(@Nonnull byte[] abFrameData, int iDataSize) throws BinaryDataNotRecognized {
        PanekitHeader header = BitStreamUncompressor_Panekit.makePanekitHeader(abFrameData, iDataSize);
        if (header == null) {
            return null;
        }
        ArrayBitReader bitReader = new ArrayBitReader(abFrameData, BitStreamUncompressor_STRv2.LITTLE_ENDIAN_SHORT_ORDER, 10 + header.getCompressedDataSize(), iDataSize);
        return new BitStreamUncompressor_Panekit(header, bitReader);
    }

    private BitStreamUncompressor_Panekit(@Nonnull PanekitHeader header, @Nonnull ArrayBitReader bitReader) {
        super(header, bitReader);
    }

    @Override
    @Nonnull
    public BitStreamCompressor_Panekit makeCompressor() {
        return new BitStreamCompressor_Panekit(this.getWidth(), this.getHeight());
    }

    public static class BitStreamCompressor_Panekit
    extends BitStreamUncompressor_Iki.BitStreamCompressor_Iki {
        private BitStreamCompressor_Panekit(int iWidth, int iHeight) {
            super(iWidth, iHeight);
        }

        @Override
        @Nonnull
        public byte[] compress(@Nonnull MdecInputStream inStream) throws IncompatibleException, MdecException.EndOfStream, MdecException.ReadCorruption {
            byte[] abNewDemux = super.compress(inStream);
            PanekitIkiObfuscation.obfuscate(abNewDemux);
            return abNewDemux;
        }
    }

    public static class PanekitHeader
    extends BitStreamUncompressor_Iki.IkiHeader {
        public PanekitHeader(int iMdecCodeCount, int iWidth, int iHeight, int iCompressedDataSize, int iBlockCount, byte[] abQscaleDcLookupTable) {
            super(iMdecCodeCount, iWidth, iHeight, iCompressedDataSize, iBlockCount, abQscaleDcLookupTable);
        }
    }
}

