/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.iso9660;

import java.io.EOFException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.iso9660.VolumePrimaryDescriptor;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.ByteArrayFPIS;

public class SectorISO9660VolumePrimaryDescriptor
extends IdentifiedSector {
    @CheckForNull
    private VolumePrimaryDescriptor _primaryDescriptor;

    public SectorISO9660VolumePrimaryDescriptor(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        int iSectNum = cdSector.getSectorIndexFromStart();
        if (iSectNum > 16) {
            return;
        }
        try {
            this._primaryDescriptor = new VolumePrimaryDescriptor(cdSector.getCdUserDataStream());
        }
        catch (EOFException ex) {
            return;
        }
        catch (IOException ex) {
            return;
        }
        catch (BinaryDataNotRecognized ex) {
            return;
        }
        this.setProbability(100);
    }

    public int getIdentifiedUserDataSize() {
        return this.getCdSector().getCdUserDataSize();
    }

    @Nonnull
    public ByteArrayFPIS getIdentifiedUserDataStream() {
        return this.getCdSector().getCdUserDataStream();
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "ISO9660 Volume Primary Descriptor";
    }

    @Nonnull
    public VolumePrimaryDescriptor getVPD() {
        if (this._primaryDescriptor == null) {
            throw new IllegalStateException();
        }
        return this._primaryDescriptor;
    }

    @Override
    public String toString() {
        return String.format("ISO PriDesc %s %s", super.toString(), this._primaryDescriptor);
    }
}

