/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.iso9660;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.iso9660.DirectoryRecord;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.ByteArrayFPIS;

public class SectorISO9660DirectoryRecords
extends IdentifiedSector
implements Iterable<DirectoryRecord> {
    @CheckForNull
    private ArrayList<DirectoryRecord> _dirRecords;

    public SectorISO9660DirectoryRecords(@Nonnull CdSector cdSector) {
        super(cdSector);
        DirectoryRecord firstRec;
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        ByteArrayFPIS sectStream = cdSector.getCdUserDataStream();
        try {
            firstRec = new DirectoryRecord(sectStream);
        }
        catch (IOException ex) {
            return;
        }
        catch (BinaryDataNotRecognized ex) {
            return;
        }
        this._dirRecords = new ArrayList();
        this._dirRecords.add(firstRec);
        try {
            while (true) {
                this._dirRecords.add(new DirectoryRecord(sectStream));
            }
        }
        catch (BinaryDataNotRecognized ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.setProbability(100);
    }

    public int getIdentifiedUserDataSize() {
        return this.getCdSector().getCdUserDataSize();
    }

    @Nonnull
    public ByteArrayFPIS getIdentifiedUserDataStream() {
        return this.getCdSector().getCdUserDataStream();
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "ISO9660 Directory Records";
    }

    @Override
    @Nonnull
    public Iterator<DirectoryRecord> iterator() {
        if (this._dirRecords == null) {
            throw new IllegalStateException();
        }
        return this._dirRecords.iterator();
    }

    @Nonnull
    public ArrayList<DirectoryRecord> getRecords() {
        if (this._dirRecords == null) {
            throw new IllegalStateException();
        }
        return this._dirRecords;
    }

    @Override
    public String toString() {
        return String.format("ISO DirRec %s %s", super.toString(), this._dirRecords);
    }
}

