/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.iso9660;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.iso9660.SectorISO9660DirectoryRecords;
import jpsxdec.modules.iso9660.SectorISO9660VolumePrimaryDescriptor;
import jpsxdec.util.IOIterator;

public class SectorClaimToSectorISO9660
implements SectorClaimSystem.SectorClaimer {
    @CheckForNull
    private static IdentifiedSector id(@Nonnull CdSector sector) {
        IdentifiedSector id = new SectorISO9660VolumePrimaryDescriptor(sector);
        if (id.getProbability() > 0) {
            return id;
        }
        id = new SectorISO9660DirectoryRecords(sector);
        if (id.getProbability() > 0) {
            return id;
        }
        return null;
    }

    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> csit, @Nonnull ILocalizedLogger log) throws IOException {
        if (cs.isClaimed()) {
            Object idSector = null;
        } else {
            IdentifiedSector idSector = SectorClaimToSectorISO9660.id(cs.getSector());
            if (idSector != null) {
                cs.claim(idSector);
            }
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
    }
}

