/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.iso9660;

import argparser.BooleanHolder;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.discitems.CombinedBuilderListener;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.discitems.IndexId;
import jpsxdec.discitems.ParagraphPanel;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.util.ArgParser;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;

public class DiscItemISO9660File
extends DiscItem {
    private static final Logger LOG = Logger.getLogger(DiscItemISO9660File.class.getName());
    public static final String TYPE_ID = "File";
    private static final String PATH_KEY = "Path";
    @Nonnull
    private final File _path;
    private static final String SIZE_KEY = "Size";
    private final long _lngSize;
    private static final String HAS_FORM2_KEY = "Has mode 2 form 2";
    private final boolean _blnHasMode2Form2;
    private static final String HAS_CD_AUDIO_KEY = "Has CD audio";
    private final boolean _blnHasCdAudio;
    private final SortedSet<DiscItem> _children = new TreeSet<DiscItem>();

    public DiscItemISO9660File(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull File path, long lngSize, boolean hasMode2Form2, boolean blnHasCdAudio) {
        super(cd, iStartSector, iEndSector);
        this._path = path;
        this._lngSize = lngSize;
        this._blnHasMode2Form2 = hasMode2Form2;
        this._blnHasCdAudio = blnHasCdAudio;
        super.setIndexId(new IndexId(path));
    }

    public DiscItemISO9660File(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._path = new File(fields.getString(PATH_KEY));
        this._lngSize = fields.getLong(SIZE_KEY);
        this._blnHasMode2Form2 = fields.getYesNo(HAS_FORM2_KEY);
        this._blnHasCdAudio = fields.getYesNo(HAS_CD_AUDIO_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem fields = super.serialize();
        fields.addNumber(SIZE_KEY, this._lngSize);
        fields.addString(PATH_KEY, Misc.forwardSlashPath(this._path));
        fields.addYesNo(HAS_FORM2_KEY, this._blnHasMode2Form2);
        fields.addYesNo(HAS_CD_AUDIO_KEY, this._blnHasCdAudio);
        return fields;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    @Nonnull
    public DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.File;
    }

    @Override
    public boolean setIndexId(@Nonnull IndexId id_ignored) {
        IndexId childId = this.getIndexId().createChild();
        for (DiscItem child : this._children) {
            if (child.setIndexId(childId)) {
                childId = childId.createNext();
                continue;
            }
            LOG.log(Level.WARNING, "Child rejected id {0}", child);
        }
        return false;
    }

    @Override
    public int getParentRating(@Nonnull DiscItem child) {
        if (child instanceof DiscItemISO9660File) {
            return 0;
        }
        return this.getOverlap(child) * 100 / child.getSectorLength();
    }

    @Override
    public boolean addChild(@Nonnull DiscItem child) {
        if (this.getParentRating(child) == 0) {
            return false;
        }
        if (!this._children.add(child)) {
            throw new RuntimeException("Disc item " + child + " already exists in ISO file set " + this);
        }
        return true;
    }

    @Override
    public int getChildCount() {
        return this._children.size();
    }

    @Nonnull
    public Iterable<DiscItem> getChildren() {
        return this._children;
    }

    @Override
    @Nonnull
    public ISO9660SaverBuilder makeSaverBuilder() {
        return new ISO9660SaverBuilder();
    }

    @Override
    public int getOverlap(@Nonnull DiscItem other) {
        int iOverlap = super.getOverlap(other);
        if (iOverlap > 0 && (other.getStartSector() < this.getStartSector() || other.getEndSector() > this.getEndSector())) {
            LOG.log(Level.WARNING, "Broke file boundary: {0} breaks {1}", new Object[]{other, this});
        }
        return iOverlap;
    }

    @Override
    @Nonnull
    public ILocalizedMessage getInterestingDescription() {
        return I.GUI_ISOFILE_DETAILS(this._lngSize);
    }

    @Nonnull
    public File getPath() {
        return this._path;
    }

    @Nonnull
    public String getFormattedPath() {
        return Misc.forwardSlashPath(this._path);
    }

    public long getSize() {
        return this._lngSize;
    }

    private static class ISO9660FileSaverBuilderGui
    extends DiscItemSaverBuilderGui {
        @Nonnull
        private final CombinedBuilderListener<ISO9660SaverBuilder> _bh;

        public ISO9660FileSaverBuilderGui(@Nonnull ISO9660SaverBuilder sourceBldr) {
            super(new BorderLayout());
            this._bh = new CombinedBuilderListener<ISO9660SaverBuilder>(sourceBldr);
            this.add((Component)new PPanel(this._bh), "North");
        }

        @Override
        public boolean useSaverBuilder(@Nonnull DiscItemSaverBuilder saverBuilder) {
            return this._bh.changeSourceBuilder(saverBuilder);
        }

        private static class PPanel
        extends ParagraphPanel {
            @Nonnull
            private final CombinedBuilderListener<ISO9660SaverBuilder> _bl;

            public PPanel(@Nonnull CombinedBuilderListener<ISO9660SaverBuilder> bl) {
                this._bl = bl;
                this._bl.addListeners(new FileName(), new SaveRaw());
            }

            private class SaveRaw
            implements ChangeListener,
            ActionListener {
                final ButtonGroup __grp = new ButtonGroup();
                final JRadioButton __normal = new JRadioButton(I.GUI_ISOFILE_SAVE_2048().getLocalizedMessage());
                final JRadioButton __raw = new JRadioButton();

                public SaveRaw() {
                    JPanel formatPanel = new JPanel();
                    formatPanel.setLayout(new BoxLayout(formatPanel, 1));
                    formatPanel.add(this.__normal);
                    formatPanel.add(this.__raw);
                    PPanel.this.add((Component)formatPanel, ParagraphLayout.NEW_LINE);
                    this.__grp.add(this.__normal);
                    this.__grp.add(this.__raw);
                    this.__normal.addActionListener(this);
                    this.__raw.addActionListener(this);
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.updateLabel();
                    boolean blnEnabled = ((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getSaveRaw_enabled();
                    boolean blnSaveRaw = ((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getSaveRaw();
                    boolean blnNormalEnabled = blnEnabled || !blnSaveRaw;
                    boolean blnRawEnabled = blnEnabled || blnSaveRaw;
                    this.__normal.setEnabled(blnNormalEnabled);
                    this.__raw.setEnabled(blnRawEnabled);
                    if (blnSaveRaw) {
                        this.__grp.setSelected(this.__raw.getModel(), true);
                    } else {
                        this.__grp.setSelected(this.__normal.getModel(), true);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == this.__normal) {
                        ((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).setSaveRaw(false);
                    } else {
                        ((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).setSaveRaw(true);
                    }
                }

                private void updateLabel() {
                    int iRawSectorSize = ((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getRawSectorSize();
                    if (iRawSectorSize == 2048) {
                        this.__raw.setText(I.GUI_ISOFILE_SAVE_RAW().getLocalizedMessage());
                    } else {
                        this.__raw.setText(I.GUI_ISOFILE_SAVE_RAW_SIZE(iRawSectorSize).getLocalizedMessage());
                    }
                }
            }

            private class FileName
            implements ChangeListener {
                final JLabel __label = new JLabel(I.GUI_SAVE_AS_LABEL().getLocalizedMessage());
                @Nonnull
                final JLabel __name;

                public FileName() {
                    this.__name = new JLabel(((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getOutputPath());
                    PPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
                    PPanel.this.add(this.__name);
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!this.__name.getText().equals(((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getOutputPath())) {
                        this.__name.setText(((ISO9660SaverBuilder)PPanel.this._bl.getBuilder()).getOutputPath());
                    }
                }
            }
        }
    }

    public class ISO9660SaverBuilder
    extends DiscItemSaverBuilder {
        private boolean __blnSaveRaw = false;

        @Override
        public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder other) {
            if (other instanceof ISO9660SaverBuilder) {
                ISO9660SaverBuilder o = (ISO9660SaverBuilder)other;
                o.setSaveRaw(this.getSaveRaw());
                return true;
            }
            return false;
        }

        @Nonnull
        public String getOutputPath() {
            return DiscItemISO9660File.this._path.getPath();
        }

        public boolean getSaveRaw() {
            if (this.getSaveRaw_enabled()) {
                return this.__blnSaveRaw;
            }
            return DiscItemISO9660File.this._blnHasCdAudio || DiscItemISO9660File.this._blnHasMode2Form2;
        }

        public void setSaveRaw(boolean blnSaveRaw) {
            this.__blnSaveRaw = blnSaveRaw;
            this.firePossibleChange();
        }

        public boolean getSaveRaw_enabled() {
            return DiscItemISO9660File.this.getSourceCd().hasSectorHeader() && !DiscItemISO9660File.this._blnHasCdAudio && !DiscItemISO9660File.this._blnHasMode2Form2;
        }

        public int getRawSectorSize() {
            return DiscItemISO9660File.this.getSourceCd().getRawSectorSize();
        }

        @Override
        @Nonnull
        public DiscItemSaverBuilderGui getOptionPane() {
            return new ISO9660FileSaverBuilderGui(this);
        }

        @Override
        public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream infoStream) {
            if (!ap.hasRemaining()) {
                return;
            }
            BooleanHolder saveRaw = ap.addBoolOption("-raw");
            ap.match();
            this.setSaveRaw(saveRaw.value);
        }

        @Override
        public void printHelp(@Nonnull FeedbackStream fbs) {
            if (this.getSaveRaw_enabled()) {
                fbs.println(I.CMD_ISOFILE_ISO_HELP(this.getRawSectorSize()));
            } else {
                fbs.println(I.CMD_ISOFILE_HELP_NO_OPTIONS());
            }
        }

        @Override
        @Nonnull
        public DiscItemISO9660File getDiscItem() {
            return DiscItemISO9660File.this;
        }

        @Override
        @Nonnull
        public ILocalizedMessage getOutputSummary() {
            return new UnlocalizedMessage(DiscItemISO9660File.this.getPath().getPath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSave(@Nonnull ProgressLogger pl, @CheckForNull File outputDir) throws LoggedFailure, TaskCanceledException {
            FileOutputStream fos;
            this.clearGeneratedFiles();
            this.printSelectedOptions(pl);
            File outputFile = new File(outputDir, DiscItemISO9660File.this.getPath().getPath());
            try {
                IO.makeDirsForFile(outputFile);
            }
            catch (LocalizedFileNotFoundException ex) {
                throw new LoggedFailure(pl, Level.SEVERE, ex.getSourceMessage(), ex);
            }
            try {
                fos = new FileOutputStream(outputFile);
                this.addGeneratedFile(outputFile);
            }
            catch (FileNotFoundException ex) {
                throw new LoggedFailure(pl, Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(outputFile.toString()), ex);
            }
            try {
                pl.progressStart(DiscItemISO9660File.this.getStartSector(), DiscItemISO9660File.this.getEndSector() + 1);
                for (int iSector = DiscItemISO9660File.this.getStartSector(); iSector <= DiscItemISO9660File.this.getEndSector(); ++iSector) {
                    CdSector cdSector;
                    if (iSector >= DiscItemISO9660File.this.getSourceCd().getSectorCount()) {
                        throw new LoggedFailure(pl, Level.SEVERE, I.NOT_CONTAINED_IN_DISC(DiscItemISO9660File.this.getFormattedPath()));
                    }
                    try {
                        cdSector = DiscItemISO9660File.this.getSourceCd().getSector(iSector);
                    }
                    catch (CdFileSectorReader.CdReadException ex) {
                        throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
                    }
                    try {
                        if (this.getSaveRaw()) {
                            fos.write(cdSector.getRawSectorDataCopy());
                        } else {
                            fos.write(cdSector.getCdUserDataCopy());
                        }
                    }
                    catch (IOException ex) {
                        throw new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(outputFile.toString()), ex);
                    }
                    pl.progressUpdate(iSector);
                }
            }
            finally {
                IO.closeSilently(fos, LOG);
            }
            pl.progressEnd();
        }

        @Override
        public void printSelectedOptions(@Nonnull ILocalizedLogger log) {
            if (this.getSaveRaw()) {
                log.log(Level.INFO, I.CMD_ISOFILE_SAVING_RAW(this.getRawSectorSize()));
            } else {
                log.log(Level.INFO, I.CMD_ISOFILE_SAVING_2048());
            }
        }
    }
}

