/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.iso9660;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.iso9660.DirectoryRecord;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.iso9660.DiscItemISO9660File;
import jpsxdec.modules.iso9660.SectorISO9660DirectoryRecords;
import jpsxdec.modules.iso9660.SectorISO9660VolumePrimaryDescriptor;
import jpsxdec.util.Misc;

public class DiscIndexerISO9660
extends DiscIndexer
implements IdentifiedSectorListener<IIdentifiedSector> {
    private static final Logger LOG = Logger.getLogger(DiscIndexerISO9660.class.getName());
    private final ArrayList<SectorISO9660DirectoryRecords> _dirRecords = new ArrayList();
    private final ArrayList<SectorISO9660VolumePrimaryDescriptor> _primaryDescriptors = new ArrayList();
    private final BitSet _sectorTypes = new BitSet();
    private static final int MODE2FORM1 = 0;
    private static final int MODE2FORM2 = 1;
    private static final int CD_AUDIO = 2;
    private static final int MODE1 = 3;
    @Nonnull
    private final ILocalizedLogger _errLog;
    private int _iSectorNumberDiff = 0;

    private void setSectorType(int iSector, int iType) {
        int iBit = iSector * 2;
        if ((iType & 1) != 0) {
            this._sectorTypes.set(iBit);
        }
        if ((iType & 2) != 0) {
            this._sectorTypes.set(iBit + 1);
        }
    }

    public DiscIndexerISO9660(@Nonnull ILocalizedLogger errLog) {
        this._errLog = errLog;
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("File".equals(fields.getType())) {
            return new DiscItemISO9660File(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this);
    }

    @Override
    @Nonnull
    public Class<IIdentifiedSector> getListeningFor() {
        return IIdentifiedSector.class;
    }

    @Override
    public void feedSector(@Nonnull IIdentifiedSector idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        IdentifiedSector isoSector = idSector instanceof SectorISO9660VolumePrimaryDescriptor || idSector instanceof SectorISO9660DirectoryRecords ? (IdentifiedSector)idSector : null;
        this.isoSectorRead(idSector.getCdSector(), isoSector);
    }

    public void isoSectorRead(@Nonnull CdSector cdSector, @Nonnull IdentifiedSector idSector) {
        int iSectorType;
        switch (cdSector.getType()) {
            case CD_AUDIO: {
                iSectorType = 2;
                break;
            }
            case UNKNOWN2048: 
            case MODE2FORM1: {
                iSectorType = 0;
                break;
            }
            case MODE2FORM2: {
                iSectorType = 1;
                break;
            }
            case MODE1: {
                iSectorType = 0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.setSectorType(cdSector.getSectorIndexFromStart(), iSectorType);
        if (idSector instanceof SectorISO9660DirectoryRecords) {
            SectorISO9660DirectoryRecords dirRectSect = (SectorISO9660DirectoryRecords)idSector;
            this._dirRecords.add(dirRectSect);
        } else if (idSector instanceof SectorISO9660VolumePrimaryDescriptor) {
            SectorISO9660VolumePrimaryDescriptor volDescriptSect = (SectorISO9660VolumePrimaryDescriptor)idSector;
            this._primaryDescriptors.add(volDescriptSect);
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        int iHeaderSector;
        if (this._primaryDescriptors.isEmpty()) {
            LOG.warning("Disc has no primary descriptor");
            return;
        }
        if (this._primaryDescriptors.size() > 1) {
            LOG.warning("Disc has more than 1 primary descriptors??");
            for (SectorISO9660VolumePrimaryDescriptor pd : this._primaryDescriptors) {
                LOG.log(Level.WARNING, "{0}", pd);
            }
            return;
        }
        this._iSectorNumberDiff = 0;
        SectorISO9660VolumePrimaryDescriptor priDesc = this._primaryDescriptors.get(0);
        CdSector cdSector = priDesc.getCdSector();
        CdSectorHeader header = cdSector.getHeader();
        if (header != null && (iHeaderSector = header.calculateSectorNumber()) != -1) {
            this._iSectorNumberDiff = iHeaderSector - cdSector.getSectorIndexFromStart();
        }
        DirectoryRecord rootDirRec = priDesc.getVPD().root_directory_record;
        if ((rootDirRec.flags & 2) == 0) {
            LOG.log(Level.WARNING, "Root directory record with only 1 file?? {0}", rootDirRec.toString());
            this.processDirectoryRecord_File(rootDirRec, new File(rootDirRec.name));
        } else {
            this.processDirectoryRecord_Directory(rootDirRec, null);
        }
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex discIndex) {
        if (this._primaryDescriptors.size() > 0) {
            discIndex.setDiscName(this._primaryDescriptors.get((int)0).getVPD().volume_id.trim());
        }
    }

    private void processDirectoryRecord(DirectoryRecord dirRec, @CheckForNull File parentPath) {
        if (dirRec.name.equals(".") || dirRec.name.equals("..")) {
            return;
        }
        File dirRecPath = new File(parentPath, dirRec.name);
        if ((dirRec.flags & 2) == 0) {
            this.processDirectoryRecord_File(dirRec, dirRecPath);
        } else {
            this.processDirectoryRecord_Directory(dirRec, dirRecPath);
        }
    }

    private void processDirectoryRecord_Directory(@Nonnull DirectoryRecord dirRec, @CheckForNull File dirRecPath) {
        assert ((dirRec.flags & 2) != 0);
        if (dirRec.extent == 0L || dirRec.size == 0L) {
            return;
        }
        int iSect = 0;
        while ((long)iSect < dirRec.size / 2048L) {
            SectorISO9660DirectoryRecords dirRecSect = this.getDirRecSector((int)(dirRec.extent + (long)this._iSectorNumberDiff + (long)iSect));
            if (dirRecSect != null) {
                for (DirectoryRecord childDirRec : dirRecSect.getRecords()) {
                    this.processDirectoryRecord(childDirRec, dirRecPath);
                }
            }
            ++iSect;
        }
    }

    @CheckForNull
    private SectorISO9660DirectoryRecords getDirRecSector(int iSector) {
        for (SectorISO9660DirectoryRecords dirRec : this._dirRecords) {
            if (dirRec.getSectorNumber() != iSector) continue;
            return dirRec;
        }
        return null;
    }

    private void processDirectoryRecord_File(@Nonnull DirectoryRecord fileDirRec, @Nonnull File filePath) {
        int iEndSector;
        assert ((fileDirRec.flags & 2) == 0);
        long lngFileSize = fileDirRec.size;
        long lngStartSector = fileDirRec.extent;
        long lngSectLength = (lngFileSize + 2047L) / 2048L;
        if (lngStartSector > Integer.MAX_VALUE || lngSectLength > Integer.MAX_VALUE || lngStartSector + lngSectLength > Integer.MAX_VALUE) {
            LOG.log(Level.SEVERE, "File with impossible start sector {0} or length {1}", new Object[]{lngStartSector, lngSectLength});
            this._errLog.log(Level.SEVERE, I.ISO_FILE_CORRUPTED_IGNORING(fileDirRec.name));
            return;
        }
        int iStartSector = (int)lngStartSector;
        if (lngFileSize == 0L) {
            iEndSector = iStartSector;
        } else {
            int iSectLength = (int)lngSectLength;
            iEndSector = iStartSector + iSectLength - 1;
        }
        this.addFileDiscItem(iStartSector, iEndSector, filePath, lngFileSize);
    }

    private void addFileDiscItem(int iStartSector, int iEndSector, @Nonnull File filePath, long lngFileSize) {
        int iSetBitPos;
        if (iEndSector > this.getCd().getSectorCount()) {
            this._errLog.log(Level.WARNING, I.NOT_CONTAINED_IN_DISC(Misc.forwardSlashPath(filePath)));
        }
        boolean blnHasCdAudio = false;
        boolean blnHasMode2Form2 = false;
        int iBit = iStartSector * 2;
        int iEndBit = (iEndSector + 1) * 2;
        while (!blnHasMode2Form2 && !blnHasCdAudio && (iSetBitPos = this._sectorTypes.nextSetBit(iBit)) >= 0 && iSetBitPos < iEndBit) {
            if (iSetBitPos % 2 == 0) {
                blnHasMode2Form2 = true;
            } else {
                blnHasCdAudio = true;
            }
            iBit = iSetBitPos;
        }
        this.addDiscItem(new DiscItemISO9660File(this.getCd(), iStartSector, iEndSector, filePath, lngFileSize, blnHasMode2Form2, blnHasCdAudio));
    }

    @Override
    public void listPostProcessing(Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }
}

