/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.granturismo;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.granturismo.GranTurismoDemuxer;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.modules.video.sectorbased.VideoSectorCommon16byteHeader;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.IO;

public class SectorGTVideo
extends IdentifiedSector
implements DemuxedData.Piece,
ISelfDemuxingVideoSector,
SectorBasedFrameReplace.IReplaceableVideoSector {
    public static final int HEADER_SIZE = 32;
    private static final long GT_MAGIC = 1397293408L;
    @Nonnull
    private final VideoSectorCommon16byteHeader _header;
    private int _iTotalFrames;
    private int _iChunkBitFlags;

    @Override
    public final int getVideoSectorHeaderSize() {
        return 32;
    }

    public SectorGTVideo(@Nonnull CdSector cdSector) {
        super(cdSector);
        this._header = new VideoSectorCommon16byteHeader(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (this.subModeExistsAndMaskDoesNotEqual(8, 8)) {
            return;
        }
        if (this._header.lngMagic != 1397293408L) {
            return;
        }
        if (!this._header.hasStandardChunkNumber()) {
            return;
        }
        if (!this._header.hasStandardChunksInFrame()) {
            return;
        }
        if (this._header.iFrameNumber < 1) {
            return;
        }
        if (!this._header.hasStandardUsedDemuxSize()) {
            return;
        }
        this._iTotalFrames = cdSector.readSInt16LE(16);
        if (this._iTotalFrames < 1) {
            return;
        }
        this._iChunkBitFlags = cdSector.readUInt16LE(18);
        if ((this._iChunkBitFlags & 0xFFFF3FFF) != 0) {
            return;
        }
        int iZero1 = cdSector.readSInt32LE(20);
        int iZero2 = cdSector.readSInt32LE(24);
        int iZero3 = cdSector.readSInt32LE(28);
        if (iZero1 != 0 || iZero2 != 0 || iZero3 != 0) {
            return;
        }
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "GT Video";
    }

    @Override
    public String toString() {
        return String.format("%s %s frame:%d/%d chunk:%d/%d flags:%04x {demux frame size=%d}", this.getTypeName(), super.cdToString(), this._header.iFrameNumber, this._iTotalFrames, this._header.iChunkNumber, this._header.iChunksInThisFrame, this._iChunkBitFlags, this._header.iUsedDemuxedSize);
    }

    public int getChunkNumber() {
        return this._header.iChunkNumber;
    }

    public int getChunksInFrame() {
        return this._header.iChunksInThisFrame;
    }

    public int getHeaderFrameNumber() {
        return this._header.iFrameNumber;
    }

    @Override
    @Nonnull
    public GranTurismoDemuxer createDemuxer(@Nonnull ILocalizedLogger log) {
        return new GranTurismoDemuxer(this, log);
    }

    @Override
    public int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
        IO.writeInt32LE(abCurrentVidSectorHeader, 12, newFrame.calculateUsedBytesRoundUp4());
    }
}

