/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.granturismo;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.granturismo.SectorGTVideo;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameBuilder;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_Iki;
import jpsxdec.util.DemuxedData;

public class GranTurismoDemuxer
implements ISelfDemuxingVideoSector.IDemuxer {
    private static final Logger LOG = Logger.getLogger(GranTurismoDemuxer.class.getName());
    @Nonnull
    private final SectorBasedFrameBuilder<SectorGTVideo> _bldr;

    public GranTurismoDemuxer(@Nonnull SectorGTVideo chunk0, @Nonnull ILocalizedLogger log) {
        if (chunk0.getChunkNumber() != 0) {
            throw new IllegalArgumentException();
        }
        this._bldr = new SectorBasedFrameBuilder<SectorGTVideo>(chunk0, chunk0.getChunkNumber(), chunk0.getChunksInFrame(), chunk0.getSectorNumber(), chunk0.getHeaderFrameNumber(), log);
    }

    @Override
    public boolean addSectorIfPartOfFrame(@Nonnull ISelfDemuxingVideoSector sector) {
        if (!(sector instanceof SectorGTVideo)) {
            return false;
        }
        return this.addGTSectorIfPartOfFrame((SectorGTVideo)sector);
    }

    public boolean addGTSectorIfPartOfFrame(@Nonnull SectorGTVideo chunk) {
        return this._bldr.addSectorIfPartOfFrame(chunk, chunk.getChunkNumber(), chunk.getChunksInFrame(), chunk.getSectorNumber(), chunk.getHeaderFrameNumber());
    }

    @Override
    public boolean isFrameComplete() {
        return this._bldr.isFrameComplete();
    }

    @Override
    @CheckForNull
    public DemuxedFrameWithNumberAndDims finishFrame(@Nonnull ILocalizedLogger log) {
        ArrayList<SectorGTVideo> sectors = this._bldr.getNonNullChunks(log);
        DemuxedData<SectorGTVideo> demux = new DemuxedData<SectorGTVideo>(sectors);
        byte[] abBitstream = demux.copyDemuxData();
        BitStreamUncompressor_Iki.IkiHeader header = BitStreamUncompressor_Iki.makeIkiHeader(abBitstream, abBitstream.length);
        if (header == null) {
            LOG.log(Level.WARNING, "Invalid GT header frame {0}", this._bldr.getHeaderFrameNumber());
            return null;
        }
        return new DemuxedFrameWithNumberAndDims(header.getWidth(), header.getHeight(), this._bldr.getHeaderFrameNumber(), sectors);
    }
}

