/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;

public class SectorEAVideo
extends IdentifiedSector
implements Iterable<EAVideoPacketSectors> {
    public static final int START = 1;
    public static final int END = 2;
    private final int _iStartEnd;
    @Nonnull
    private List<EAVideoPacketSectors> _packetsEndingInThisSector = Collections.emptyList();

    public SectorEAVideo(@Nonnull CdSector cdSector, int iStartEnd) {
        super(cdSector);
        this._iStartEnd = iStartEnd;
        this.setProbability(100);
    }

    @Override
    public String getTypeName() {
        return "EA video";
    }

    void setPacketsEndingInThisSector(@Nonnull List<EAVideoPacketSectors> packetsEndingInThisSector) {
        this._packetsEndingInThisSector = packetsEndingInThisSector;
    }

    @Override
    @Nonnull
    public Iterator<EAVideoPacketSectors> iterator() {
        return this._packetsEndingInThisSector.iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTypeName()).append(' ').append(super.toString()).append(' ').append(this._packetsEndingInThisSector.size()).append(" finished packets [");
        for (int i = 0; i < this._packetsEndingInThisSector.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._packetsEndingInThisSector.get(i));
        }
        sb.append(']');
        if ((this._iStartEnd & 1) != 0) {
            sb.append(" START");
        }
        if ((this._iStartEnd & 2) != 0) {
            sb.append(" END");
        }
        return sb.toString();
    }
}

