/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.eavideo.EAVideoPacket;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;
import jpsxdec.modules.eavideo.SectorEAVideo;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.IOIterator;
import jpsxdec.util.PushAvailableInputStream;

public class SectorClaimToEAVideo
implements SectorClaimSystem.SectorClaimer {
    @CheckForNull
    private EAVideoStreamReader _sectorStream;

    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        CdSector cdSector = cs.getSector();
        if (cs.getClaimer() != null || cdSector.isCdAudioSector()) {
            this.endVideo(log);
            return;
        }
        try {
            SectorEAVideo eaSector = null;
            if (this._sectorStream == null) {
                long lngMagic = cdSector.readUInt32BE(0);
                if (lngMagic == 1447838512L) {
                    EAVideoPacket.VLC0 vlcPacket;
                    try {
                        vlcPacket = EAVideoPacket.readVlc0(cdSector.getCdUserDataStream());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Should not happen", ex);
                    }
                    if (vlcPacket != null) {
                        this._sectorStream = new EAVideoStreamReader();
                        eaSector = this._sectorStream.readSectorPackets(cdSector, vlcPacket);
                    }
                }
            } else {
                eaSector = this._sectorStream.readSectorPackets(cdSector, null);
            }
            if (eaSector != null) {
                cs.claim(eaSector);
            }
            if (this._sectorStream != null && this._sectorStream.isEnd()) {
                this.endVideo(log);
            }
        }
        catch (BinaryDataNotRecognized ex) {
            log.log(Level.SEVERE, I.EA_VIDEO_DATA_CORRUPTION(), ex);
            this._sectorStream = null;
        }
    }

    private void endVideo(@Nonnull ILocalizedLogger log) {
        if (this._sectorStream != null) {
            this._sectorStream = null;
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
        this.endVideo(log);
    }

    private static class EAVideoStreamReader {
        @Nonnull
        private final PushAvailableInputStream<CdSector> _sectorStream = new PushAvailableInputStream();
        @CheckForNull
        private EAVideoPacket.Type _headerType;
        @CheckForNull
        private EAVideoPacket.Header _header;
        private int _iCurrentPacketStartSector;
        private boolean _blnEnd = false;

        private EAVideoStreamReader() {
        }

        public boolean isEnd() {
            return this._blnEnd;
        }

        @Nonnull
        public SectorEAVideo readSectorPackets(@Nonnull CdSector sector, @CheckForNull EAVideoPacket.VLC0 vlc) throws BinaryDataNotRecognized {
            if (this._blnEnd) {
                throw new IllegalStateException();
            }
            try {
                ByteArrayFPIS is = sector.getCdUserDataStream();
                if (vlc != null) {
                    is.skip(EAVideoPacket.VLC0.SIZEOF);
                }
                this._sectorStream.addStream(is, sector);
                return this.readSectorPacketsThrowsIOEx(sector, vlc);
            }
            catch (IOException ex) {
                throw new RuntimeException("Should not happen", ex);
            }
        }

        @Nonnull
        private SectorEAVideo readSectorPacketsThrowsIOEx(@Nonnull CdSector sector, @CheckForNull EAVideoPacket.VLC0 vlc) throws BinaryDataNotRecognized, IOException {
            ArrayList<EAVideoPacketSectors> finishedPackets = null;
            if (vlc != null) {
                finishedPackets = new ArrayList<EAVideoPacketSectors>(5);
                finishedPackets.add(new EAVideoPacketSectors(vlc, sector.getSectorIndexFromStart(), sector.getSectorIndexFromStart()));
            }
            while (true) {
                if (this._header == null) {
                    if (this._headerType == null) {
                        if (this._sectorStream.available() < 4) break;
                        this._iCurrentPacketStartSector = this._sectorStream.getCurrentMeta().getSectorIndexFromStart();
                        this._headerType = EAVideoPacket.readHeaderType(this._sectorStream);
                        if (this._headerType != EAVideoPacket.Type.ZEROES) continue;
                        this._blnEnd = true;
                        break;
                    }
                    if (this._sectorStream.available() < this._headerType.bytesNeededToFinishHeader()) break;
                    this._header = this._headerType.readHeader(this._sectorStream);
                    this._headerType = null;
                    continue;
                }
                if (this._sectorStream.available() < this._header.getPayloadSize()) break;
                int iBefore = this._sectorStream.available();
                EAVideoPacket packet = this._header.readPacket(this._sectorStream);
                int iAfter = this._sectorStream.available();
                if (this._header.getPayloadSize() != iBefore - iAfter) {
                    throw new RuntimeException();
                }
                assert (this._sectorStream.getCurrentMeta() == sector);
                if (finishedPackets == null) {
                    finishedPackets = new ArrayList(5);
                }
                int iPacketEndSector = this._sectorStream.getCurrentMeta().getSectorIndexFromStart();
                finishedPackets.add(new EAVideoPacketSectors(packet, this._iCurrentPacketStartSector, iPacketEndSector));
                this._header = null;
            }
            int iStartEnd = 0;
            if (vlc != null) {
                iStartEnd = 1;
            }
            if (this._blnEnd) {
                iStartEnd += 2;
            }
            SectorEAVideo rrSector = new SectorEAVideo(sector, iStartEnd);
            if (finishedPackets != null) {
                rrSector.setPacketsEndingInThisSector(finishedPackets);
            }
            return rrSector;
        }
    }
}

