/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.adpcm.SpuAdpcmSoundUnit;
import jpsxdec.modules.eavideo.BitStreamUncompressor_EA;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAc;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.Fraction;
import jpsxdec.util.IO;

public abstract class EAVideoPacket {
    public static final int FRAMES_PER_SECOND = 15;
    public static final int SECTORS150_PER_FRAME = 10;
    public static final int SAMPLE_FRAMES_PER_SECOND = 22050;
    public static final int SAMPLE_FRAMES_PER_SECTOR = 147;
    public static final int MIN_PACKET_SIZE = 32;
    public static final int MAX_PACKET_SIZE = 102400;
    private static final int MAX_PRESENTATION_SAMPLE_FRAME = 13230000;
    private static final int MAX_FRAME_NUMBER = 9000;
    private static final int MIN_FRAME_DIMENSIONS = 16;
    private static final int MAX_FRAME_DIMENSIONS = 640;
    public static final long MAGIC_VLC0 = 1447838512L;
    private static final long MAGIC_MDEC = 1296319811L;
    private static final long MAGIC_au00 = 1635070000L;
    private static final long MAGIC_au01 = 1635070001L;
    public static final AudioFormat EA_VIDEO_AUDIO_FORMAT = new AudioFormat(22050.0f, 16, 2, true, false);
    private static int _iMinPacketSize = Integer.MAX_VALUE;
    private static int _iMaxPacketSize = 0;
    @Nonnull
    private final Header _header;
    private static int _iMaxPresentationSampleFrame = 0;
    private static int _iMinAuPacketSize = Integer.MAX_VALUE;
    private static int _iMaxAuPacketSize = 0;
    private static int _iMinMdecPacketSize = Integer.MAX_VALUE;
    private static int _iMaxMdecPacketSize = 0;
    private static int _iMinWidth = Integer.MAX_VALUE;
    private static int _iMaxWidth = 0;
    private static int _iMinHeight = Integer.MAX_VALUE;
    private static int _iMaxHeight = 0;
    private static int _iMaxFrameNumber = 0;

    @Nonnull
    public static Type readHeaderType(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        long lngPacketType = IO.readUInt32BE(is);
        if (lngPacketType == 1635070000L) {
            return Type.au00;
        }
        if (lngPacketType == 1635070001L) {
            return Type.au01;
        }
        if (lngPacketType == 1296319811L) {
            return Type.MDEC;
        }
        if (lngPacketType == 0L) {
            return Type.ZEROES;
        }
        if (lngPacketType == 1447838512L) {
            return Type.VLC0;
        }
        throw new BinaryDataNotRecognized("Unknown packet type %08x", lngPacketType);
    }

    private EAVideoPacket(@Nonnull Header header) {
        this._header = header;
    }

    @Nonnull
    public Type getPacketType() {
        return this._header._packetType;
    }

    public int getPacketSizeInHeader() {
        return this._header._iHeaderPacketSize;
    }

    @CheckForNull
    public static VLC0 readVlc0(@Nonnull InputStream is) throws EOFException, IOException {
        try {
            Type type = EAVideoPacket.readHeaderType(is);
            if (type != Type.VLC0) {
                return null;
            }
            Header header = type.doReadHeader(is, false);
            if (header == null) {
                return null;
            }
            VLC0 vlc = VLC0.read(header, is, false);
            return vlc;
        }
        catch (BinaryDataNotRecognized ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    @Nonnull
    private static List<SpuAdpcmSoundUnit> unpackSpu(@Nonnull byte[] abPayload) {
        ArrayList<SpuAdpcmSoundUnit> units = new ArrayList<SpuAdpcmSoundUnit>();
        int iBytesUsed = 0;
        while (iBytesUsed + 14 < abPayload.length) {
            byte[] abSpuSoundUnit = new byte[16];
            abSpuSoundUnit[0] = abPayload[iBytesUsed];
            abSpuSoundUnit[1] = 0;
            System.arraycopy(abPayload, iBytesUsed + 1, abSpuSoundUnit, 2, 14);
            units.add(new SpuAdpcmSoundUnit(abSpuSoundUnit));
            iBytesUsed += 15;
        }
        return units;
    }

    public static class MDEC
    extends EAVideoPacket {
        private final int _iWidth;
        private final int _iHeight;
        private final int _iFrameNumber;
        @Nonnull
        private final BitStreamUncompressor_STRv2.StrV2Header _strHeader;
        @Nonnull
        private final byte[] _abBitstream;

        public MDEC(@Nonnull Header header, @Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
            super(header);
            if (header._iHeaderPacketSize < _iMinMdecPacketSize) {
                _iMinMdecPacketSize = header._iHeaderPacketSize;
            }
            if (header._iHeaderPacketSize > _iMaxMdecPacketSize) {
                _iMaxMdecPacketSize = header._iHeaderPacketSize;
            }
            this._iWidth = IO.readSInt16BE(is);
            this._iHeight = IO.readSInt16BE(is);
            if (this._iWidth < 16 || this._iWidth > 640 || this._iHeight < 16 || this._iHeight > 640) {
                throw new BinaryDataNotRecognized("Unexpected dimensions %dx%d", this._iWidth, this._iHeight);
            }
            if (this._iWidth < _iMinWidth) {
                _iMinWidth = this._iWidth;
            }
            if (this._iWidth > _iMaxWidth) {
                _iMaxWidth = this._iWidth;
            }
            if (this._iHeight < _iMinHeight) {
                _iMinHeight = this._iHeight;
            }
            if (this._iHeight > _iMaxHeight) {
                _iMaxHeight = this._iHeight;
            }
            this._iFrameNumber = IO.readSInt32BE(is);
            if ((this._iFrameNumber < 0 || this._iFrameNumber > 9000) && this._iFrameNumber != 2147462428) {
                throw new BinaryDataNotRecognized("Unexpected frame number " + this._iFrameNumber);
            }
            if (this._iFrameNumber > _iMaxFrameNumber) {
                _iMaxFrameNumber = this._iFrameNumber;
            }
            byte[] abStrHeader = IO.readByteArray(is, 8);
            this._strHeader = new BitStreamUncompressor_STRv2.StrV2Header(abStrHeader, abStrHeader.length);
            if (!this._strHeader.isValid()) {
                throw new BinaryDataNotRecognized("Invalid STRv2 header");
            }
            this._abBitstream = IO.readByteArray(is, header._iHeaderPacketSize - 8 - 8 - abStrHeader.length);
        }

        public int getWidth() {
            return this._iWidth;
        }

        public int getHeight() {
            return this._iHeight;
        }

        public int getFrameNumber() {
            return this._iFrameNumber;
        }

        public int getQuantizationScale() {
            return this._strHeader.getQuantizationScale();
        }

        @Nonnull
        public byte[] getBitstream() {
            return this._abBitstream;
        }

        public String toString() {
            return String.format("MDEC %dx%d frame:%d qscale:%d", this._iWidth, this._iHeight, this._iFrameNumber, this._strHeader.getQuantizationScale());
        }
    }

    public static class AU
    extends EAVideoPacket {
        private final int _iPresentationSampleFrame;
        @Nonnull
        private final byte[] _abCompressedSpu;

        public AU(@Nonnull Header header, @Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
            super(header);
            int i2048;
            if (header._iHeaderPacketSize < _iMinAuPacketSize) {
                _iMinAuPacketSize = header._iHeaderPacketSize;
            }
            if (header._iHeaderPacketSize > _iMaxAuPacketSize) {
                _iMaxAuPacketSize = header._iHeaderPacketSize;
            }
            this._iPresentationSampleFrame = IO.readSInt32BE(is);
            if (this._iPresentationSampleFrame < 0 || this._iPresentationSampleFrame > 13230000) {
                throw new BinaryDataNotRecognized("Unexpected presentation sample frame " + this._iPresentationSampleFrame);
            }
            if (this._iPresentationSampleFrame > _iMaxPresentationSampleFrame) {
                _iMaxPresentationSampleFrame = this._iPresentationSampleFrame;
            }
            if ((i2048 = IO.readSInt16BE(is)) != 2048) {
                throw new BinaryDataNotRecognized("%d != 2048", i2048);
            }
            int i512 = IO.readSInt16BE(is);
            if (i512 != 512) {
                throw new BinaryDataNotRecognized("%d != 512", i512);
            }
            this._abCompressedSpu = IO.readByteArray(is, header._iHeaderPacketSize - 8 - 8);
        }

        public boolean isLastAudioPacket() {
            return this.getPacketType() == Type.au01;
        }

        public int calcSampleFramesGenerated() {
            return this.getSpuSoundUnitPairCount() * 28;
        }

        public int getSpuSoundUnitPairCount() {
            int iSoundUnits = this._abCompressedSpu.length / 15;
            return iSoundUnits / 2;
        }

        @Nonnull
        public DecodedAudioPacket decode(@Nonnull SpuAdpcmDecoder.Stereo decoder) {
            List units = EAVideoPacket.unpackSpu(this._abCompressedSpu);
            int iHalf = units.size() / 2;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int iUnit = 0; iUnit < iHalf; ++iUnit) {
                try {
                    decoder.decode((SpuAdpcmSoundUnit)units.get(iUnit), (SpuAdpcmSoundUnit)units.get(iHalf + iUnit), out);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Should not happen", ex);
                }
            }
            if (out.size() != this.calcSampleFramesGenerated() * 4) {
                throw new RuntimeException();
            }
            Fraction presentationSector = new Fraction(this._iPresentationSampleFrame, 147L);
            return new DecodedAudioPacket(0, EA_VIDEO_AUDIO_FORMAT, presentationSector, out.toByteArray());
        }

        public String toString() {
            return String.format("%s start sample frame:%d sample frames:%d", this.getPacketType().name(), this._iPresentationSampleFrame, this.calcSampleFramesGenerated());
        }
    }

    public static class VLC0
    extends EAVideoPacket {
        public static final int SIZEOF = 8 + BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER.length * 2;
        @Nonnull
        private final ZeroRunLengthAcLookup _vlcLookup;
        @Nonnull
        private final MdecCode[] _aoVlcHeaderMdecCodesForReference;

        private static VLC0 read(@Nonnull Header header, @Nonnull InputStream is, boolean blnThrowEx) throws BinaryDataNotRecognized, EOFException, IOException {
            if (header._iHeaderPacketSize != BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER.length * 2 + 8) {
                if (blnThrowEx) {
                    throw new BinaryDataNotRecognized();
                }
                return null;
            }
            byte[] abPacketPayload = IO.readByteArray(is, header._iHeaderPacketSize - 8);
            ZeroRunLengthAcLookup.Builder bldr = new ZeroRunLengthAcLookup.Builder();
            MdecCode[] aoVlcHeaderMdecCodesForReference = new MdecCode[BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER.length];
            for (int i = 0; i < BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER.length; ++i) {
                int iMdec = IO.readUInt16LE(abPacketPayload, i * 2);
                MdecCode mdecCode = new MdecCode(iMdec);
                if (!mdecCode.isValid()) {
                    if (blnThrowEx) {
                        throw new BinaryDataNotRecognized();
                    }
                    return null;
                }
                aoVlcHeaderMdecCodesForReference[i] = mdecCode;
                ZeroRunLengthAc bitCode = new ZeroRunLengthAc(BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER[i], mdecCode.getTop6Bits(), mdecCode.getBottom10Bits(), mdecCode.toMdecWord() == 31775, mdecCode.isEOD());
                bldr.add(bitCode);
            }
            return new VLC0(header, bldr.build(), aoVlcHeaderMdecCodesForReference);
        }

        private VLC0(@Nonnull Header header, @Nonnull ZeroRunLengthAcLookup vlcLookup, @Nonnull MdecCode[] aoVlcHeaderMdecCodesForReference) {
            super(header);
            this._aoVlcHeaderMdecCodesForReference = aoVlcHeaderMdecCodesForReference;
            this._vlcLookup = vlcLookup;
        }

        @Nonnull
        public BitStreamUncompressor makeFrameBitStreamUncompressor(@Nonnull MDEC mdecPacket) {
            return new BitStreamUncompressor_EA(mdecPacket.getBitstream(), this._vlcLookup, mdecPacket.getQuantizationScale());
        }

        public void printCodes() {
            for (int i = 0; i < this._aoVlcHeaderMdecCodesForReference.length; ++i) {
                MdecCode mdec = this._aoVlcHeaderMdecCodesForReference[i];
                System.out.format("%04X %-8s %s", new Object[]{mdec.toMdecWord(), mdec, BitStreamUncompressor_EA.EA_VIDEO_BIT_CODE_ORDER[i]});
                if (mdec.toMdecWord() == 31775) {
                    System.out.println(" (escape code)");
                    continue;
                }
                System.out.println();
            }
        }

        public String toString() {
            return "VLC0";
        }
    }

    public static class Header {
        @Nonnull
        private final Type _packetType;
        private final int _iHeaderPacketSize;

        private Header(@Nonnull Type type, int iHeaderPacketSize) {
            this._packetType = type;
            this._iHeaderPacketSize = iHeaderPacketSize;
        }

        @Nonnull
        public Type getPacketType() {
            return this._packetType;
        }

        public int getPayloadSize() {
            return this._iHeaderPacketSize - 8;
        }

        @Nonnull
        public EAVideoPacket readPacket(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
            if (this._packetType == Type.au00 || this._packetType == Type.au01) {
                return new AU(this, is);
            }
            if (this._packetType == Type.MDEC) {
                return new MDEC(this, is);
            }
            if (this._packetType == Type.VLC0) {
                return VLC0.read(this, is, true);
            }
            throw new RuntimeException("?");
        }

        public String toString() {
            return String.format("Header %s size %d", new Object[]{this._packetType, this._iHeaderPacketSize});
        }
    }

    public static enum Type {
        VLC0,
        MDEC,
        au00,
        au01,
        ZEROES;

        public static final int SIZEOF = 4;

        public int bytesNeededToFinishHeader() {
            return 4;
        }

        @Nonnull
        public Header readHeader(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
            return this.doReadHeader(is, true);
        }

        @CheckForNull
        private Header doReadHeader(@Nonnull InputStream is, boolean blnThrowEx) throws EOFException, IOException, BinaryDataNotRecognized {
            int iHeaderPacketSize = IO.readSInt32BE(is);
            if (iHeaderPacketSize % 4 != 0) {
                if (blnThrowEx) {
                    throw new BinaryDataNotRecognized("Invalid packet size " + iHeaderPacketSize);
                }
                return null;
            }
            if (iHeaderPacketSize < 32 || iHeaderPacketSize > 102400) {
                if (blnThrowEx) {
                    throw new BinaryDataNotRecognized("Invalid packet size " + iHeaderPacketSize);
                }
                return null;
            }
            if (iHeaderPacketSize < _iMinPacketSize) {
                _iMinPacketSize = iHeaderPacketSize;
            }
            if (iHeaderPacketSize > _iMaxPacketSize) {
                _iMaxPacketSize = iHeaderPacketSize;
            }
            return new Header(this, iHeaderPacketSize);
        }
    }
}

