/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;
import jpsxdec.modules.eavideo.SectorEAVideo;

public class EASectorToEAPacket
implements IdentifiedSectorListener<IIdentifiedSector> {
    private final ArrayList<Listener> _listeners = new ArrayList();

    public static void attachToSectorClaimer(@Nonnull SectorClaimSystem scs, @Nonnull Listener listener) {
        EASectorToEAPacket s2p = scs.getIdListener(EASectorToEAPacket.class);
        if (s2p == null) {
            s2p = new EASectorToEAPacket(listener);
            scs.addIdListener(s2p);
        } else {
            s2p.addListener(listener);
        }
    }

    private EASectorToEAPacket(@Nonnull Listener listener) {
        this._listeners.add(listener);
    }

    private void addListener(@Nonnull Listener newListener) {
        for (Listener listener : this._listeners) {
            if (listener != newListener) continue;
            return;
        }
        this._listeners.add(newListener);
    }

    @Override
    @Nonnull
    public Class<IIdentifiedSector> getListeningFor() {
        return IIdentifiedSector.class;
    }

    @Override
    public void feedSector(@Nonnull IIdentifiedSector idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (idSector instanceof SectorEAVideo) {
            SectorEAVideo eaSector = (SectorEAVideo)idSector;
            for (EAVideoPacketSectors finishedPacket : eaSector) {
                for (Listener listener : this._listeners) {
                    listener.feedPacket(finishedPacket, log);
                }
            }
        } else {
            this.endVideo(log);
        }
    }

    public void endVideo(@Nonnull ILocalizedLogger log) {
        for (Listener listener : this._listeners) {
            listener.endVideo(log);
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        this.endVideo(log);
    }

    public static interface Listener {
        public void feedPacket(@Nonnull EAVideoPacketSectors var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void endVideo(@Nonnull ILocalizedLogger var1);
    }
}

