/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.eavideo.DemuxedEAFrame;
import jpsxdec.modules.eavideo.EASectorToEAPacket;
import jpsxdec.modules.eavideo.EAVideoPacket;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatter;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.packetbased.DiscItemPacketBasedVideoStream;
import jpsxdec.modules.video.packetbased.SectorClaimToAudioAndFrame;
import jpsxdec.util.Fraction;

public class DiscItemEAVideo
extends DiscItemPacketBasedVideoStream {
    public static final String TYPE_ID = "EA Video";
    private static final int SECTORS_PER_FRAME = 10;
    private static final int FPS = 15;
    @CheckForNull
    private final HeaderFrameNumber.Format _headerFrameNumberFormat;

    public DiscItemEAVideo(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format sectorIndexFrameNumberFormat, @CheckForNull HeaderFrameNumber.Format headerFrameNumberFormat, int iSoundUnitCount) {
        super(cd, iStartSector, iEndSector, dim, sectorIndexFrameNumberFormat, iSoundUnitCount);
        this._headerFrameNumberFormat = headerFrameNumberFormat;
    }

    public DiscItemEAVideo(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._headerFrameNumberFormat = fields.hasField("Header Frames") ? new HeaderFrameNumber.Format(fields) : null;
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        if (this._headerFrameNumberFormat != null) {
            this._headerFrameNumberFormat.serialize(serial);
        }
        return serial;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return false;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        if (this._headerFrameNumberFormat == null) {
            return this._indexSectorFrameNumberFormat.getStartFrame();
        }
        return this._headerFrameNumberFormat.getStartFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public FrameNumber getEndFrame() {
        if (this._headerFrameNumberFormat == null) {
            return this._indexSectorFrameNumberFormat.getEndFrame();
        }
        return this._headerFrameNumberFormat.getEndFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        if (this._headerFrameNumberFormat == null) {
            return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Sector);
        }
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Header, FrameNumber.Type.Sector);
    }

    @Override
    protected double getPacketBasedFpsInterestingDescription() {
        return 15.0;
    }

    @Override
    @Nonnull
    public Fraction getSectorsPerFrame() {
        return new Fraction(10);
    }

    @Override
    public double getApproxDuration() {
        return (double)this.getFrameCount() / 15.0;
    }

    @Override
    public int getAudioSampleFramesPerSecond() {
        if (this.hasAudio()) {
            return 22050;
        }
        return -1;
    }

    @Override
    @Nonnull
    public SectorClaimToAudioAndFrame makeAudioVideoDemuxer(double dblVolume) {
        if (this._headerFrameNumberFormat != null) {
            return new Demuxer(dblVolume, this._headerFrameNumberFormat.makeFormatter(this._indexSectorFrameNumberFormat), null);
        }
        return new Demuxer(dblVolume, null, this._indexSectorFrameNumberFormat.makeFormatter());
    }

    public class Demuxer
    extends SectorClaimToAudioAndFrame
    implements EASectorToEAPacket.Listener {
        @CheckForNull
        private final IFrameNumberFormatterWithHeader _fnfwh;
        @CheckForNull
        private final IFrameNumberFormatter _fnf;
        @Nonnull
        private final SpuAdpcmDecoder.Stereo _audioDecoder;
        @CheckForNull
        private IDemuxedFrame.Listener _frameListener;
        @CheckForNull
        private DecodedAudioPacket.Listener _audioListener;
        @CheckForNull
        private EAVideoPacket.VLC0 _vlcPacket;
        private final SectorRange _sectorRange;

        public Demuxer(@CheckForNull double dblVolume, @CheckForNull IFrameNumberFormatterWithHeader fnfwh, IFrameNumberFormatter fnf) {
            this._sectorRange = DiscItemEAVideo.this.makeSectorRange();
            this._audioDecoder = new SpuAdpcmDecoder.Stereo(dblVolume);
            this._fnfwh = fnfwh;
            this._fnf = fnf;
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            EASectorToEAPacket.attachToSectorClaimer(scs, this);
        }

        @Override
        public void feedPacket(@Nonnull EAVideoPacketSectors packet, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            if (!this._sectorRange.sectorIsInRange(packet.iStartSector) || !this._sectorRange.sectorIsInRange(packet.iEndSector)) {
                return;
            }
            if (packet.packet instanceof EAVideoPacket.AU) {
                EAVideoPacket.AU au = (EAVideoPacket.AU)packet.packet;
                DecodedAudioPacket aup = au.decode(this._audioDecoder);
                if (this._audioListener != null) {
                    this._audioListener.audioPacketComplete(aup, log);
                }
            } else if (packet.packet instanceof EAVideoPacket.MDEC) {
                FrameNumber fn;
                EAVideoPacket.MDEC mdecPacket = (EAVideoPacket.MDEC)packet.packet;
                int iFrameNumber = mdecPacket.getFrameNumber();
                if (this._fnf != null) {
                    fn = this._fnf.next(packet.iStartSector, log);
                    iFrameNumber = fn.getIndexNumber().getFrameValue();
                } else {
                    fn = this._fnfwh.next(packet.iStartSector, mdecPacket.getFrameNumber(), log);
                }
                if (this._vlcPacket != null && this._frameListener != null) {
                    int iPresentationSector = iFrameNumber * 10 + DiscItemEAVideo.this.getAbsolutePresentationStartSector();
                    this._frameListener.frameComplete(new DemuxedEAFrame(packet, mdecPacket, this._vlcPacket, fn, new Fraction(iPresentationSector)));
                }
            } else if (packet.packet instanceof EAVideoPacket.VLC0) {
                this._vlcPacket = (EAVideoPacket.VLC0)packet.packet;
            }
        }

        @Override
        public void endVideo(@Nonnull ILocalizedLogger log) {
        }

        @Override
        public void setFrameListener(@CheckForNull IDemuxedFrame.Listener listener) {
            this._frameListener = listener;
        }

        @Override
        public void setAudioListener(@CheckForNull DecodedAudioPacket.Listener listener) {
            this._audioListener = listener;
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat() {
            return EAVideoPacket.EA_VIDEO_AUDIO_FORMAT;
        }

        @Override
        public double getVolume() {
            return this._audioDecoder.getVolume();
        }

        @Override
        public int getAbsolutePresentationStartSector() {
            return DiscItemEAVideo.this.getStartSector();
        }

        @Override
        public int getStartSector() {
            return DiscItemEAVideo.this.getStartSector();
        }

        @Override
        public int getEndSector() {
            return DiscItemEAVideo.this.getEndSector();
        }

        @Override
        public int getSampleFramesPerSecond() {
            return 22050;
        }

        @Override
        public int getDiscSpeed() {
            return 2;
        }
    }
}

