/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.eavideo.DiscItemEAVideo;
import jpsxdec.modules.eavideo.EASectorToEAPacket;
import jpsxdec.modules.eavideo.EAVideoPacket;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.util.BinaryDataNotRecognized;

public class DiscIndexerEAVideo
extends DiscIndexer
implements EASectorToEAPacket.Listener {
    private static final Logger LOG = Logger.getLogger(DiscIndexerEAVideo.class.getName());
    @CheckForNull
    private MovieBuilder _movieBuilder;

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        EASectorToEAPacket.attachToSectorClaimer(scs, this);
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("EA Video".equals(fields.getType())) {
            return new DiscItemEAVideo(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    @Override
    public void feedPacket(@Nonnull EAVideoPacketSectors packet, @Nonnull ILocalizedLogger log) {
        try {
            if (this._movieBuilder == null) {
                if (!(packet.packet instanceof EAVideoPacket.VLC0)) {
                    throw new BinaryDataNotRecognized();
                }
                this._movieBuilder = new MovieBuilder(packet.iStartSector);
            } else if (packet.packet instanceof EAVideoPacket.VLC0) {
                this.endVideo(log);
                this._movieBuilder = new MovieBuilder(packet.iStartSector);
            } else {
                this._movieBuilder.addPacket(packet);
            }
        }
        catch (BinaryDataNotRecognized ex) {
            LOG.log(Level.SEVERE, "EA video data corruption", ex);
            this.endVideo(log);
        }
    }

    @Override
    public void endVideo(@Nonnull ILocalizedLogger log) {
        if (this._movieBuilder != null) {
            try {
                DiscItemEAVideo item = this._movieBuilder.makeItem(this.getCd());
                this.addDiscItem(item);
            }
            catch (BinaryDataNotRecognized ex) {
                LOG.log(Level.SEVERE, "EA video data corruption", ex);
            }
            this._movieBuilder = null;
        }
    }

    private static class MovieBuilder {
        @CheckForNull
        private VidBuilder _vidBuilder;
        @Nonnull
        private int _iSpuSoundUnitPairCount = 0;
        private final int _iStartSector;
        private int _iEndSector;

        public MovieBuilder(int iStartSector) {
            this._iStartSector = iStartSector;
            this._iEndSector = iStartSector;
        }

        public void addPacket(@Nonnull EAVideoPacketSectors packet) throws BinaryDataNotRecognized {
            this._iEndSector = packet.iEndSector;
            if (packet.packet instanceof EAVideoPacket.AU) {
                EAVideoPacket.AU au = (EAVideoPacket.AU)packet.packet;
                this._iSpuSoundUnitPairCount += au.getSpuSoundUnitPairCount();
            } else if (packet.packet instanceof EAVideoPacket.MDEC) {
                if (this._vidBuilder == null) {
                    this._vidBuilder = new VidBuilder((EAVideoPacket.MDEC)packet.packet, packet.iStartSector);
                } else {
                    this._vidBuilder.addFrame((EAVideoPacket.MDEC)packet.packet, packet.iStartSector);
                }
            } else {
                if (packet.packet instanceof EAVideoPacket.VLC0) {
                    throw new BinaryDataNotRecognized();
                }
                throw new RuntimeException("??");
            }
        }

        @Nonnull
        public DiscItemEAVideo makeItem(@Nonnull CdFileSectorReader cd) throws BinaryDataNotRecognized {
            if (this._vidBuilder == null) {
                throw new BinaryDataNotRecognized();
            }
            DiscItemEAVideo item = new DiscItemEAVideo(cd, this._iStartSector, this._iEndSector, this._vidBuilder._dims, this._vidBuilder._indexSectorFrameNumberBuilder.makeFormat(), this._vidBuilder.getFrameFormat(), this._iSpuSoundUnitPairCount);
            return item;
        }
    }

    private static class VidBuilder {
        @Nonnull
        private final Dimensions _dims;
        @Nonnull
        private final IndexSectorFrameNumber.Format.Builder _indexSectorFrameNumberBuilder;
        @Nonnull
        private final HeaderFrameNumber.Format.Builder _headerFrameNumberBuilder;

        public VidBuilder(@Nonnull EAVideoPacket.MDEC firstMdec, int iStartSector) {
            this._dims = new Dimensions(firstMdec.getWidth(), firstMdec.getHeight());
            this._indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(iStartSector);
            this._headerFrameNumberBuilder = new HeaderFrameNumber.Format.Builder(firstMdec.getFrameNumber());
        }

        public void addFrame(@Nonnull EAVideoPacket.MDEC mdec, int iStartSector) throws BinaryDataNotRecognized {
            if (!this._dims.equals(mdec.getWidth(), mdec.getHeight()) || mdec.getFrameNumber() < this._headerFrameNumberBuilder.getLastFrameNumber()) {
                throw new BinaryDataNotRecognized("EA video data corruption");
            }
            this._headerFrameNumberBuilder.addHeaderFrameNumber(mdec.getFrameNumber());
            this._indexSectorFrameNumberBuilder.addFrameStartSector(iStartSector);
        }

        public HeaderFrameNumber.Format getFrameFormat() {
            if (this._headerFrameNumberBuilder.getStartFrameNumber() != this._headerFrameNumberBuilder.getLastFrameNumber()) {
                return this._headerFrameNumberBuilder.makeFormat();
            }
            return null;
        }
    }
}

