/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.eavideo;

import java.io.PrintStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.eavideo.EAVideoPacket;
import jpsxdec.modules.eavideo.EAVideoPacketSectors;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.Fraction;

public class DemuxedEAFrame
implements IDemuxedFrame {
    @Nonnull
    private final EAVideoPacketSectors _sectors;
    @Nonnull
    private final EAVideoPacket.MDEC _mdecPacket;
    @Nonnull
    private final EAVideoPacket.VLC0 _vlc;
    @Nonnull
    private final FrameNumber _frameNumber;
    @Nonnull
    private final Fraction _presentationSector;

    public DemuxedEAFrame(@Nonnull EAVideoPacketSectors sectors, @Nonnull EAVideoPacket.MDEC mdecPacket, @Nonnull EAVideoPacket.VLC0 vlc, @Nonnull FrameNumber frameNumber, @Nonnull Fraction presentationSector) {
        this._sectors = sectors;
        this._mdecPacket = mdecPacket;
        this._vlc = vlc;
        this._frameNumber = frameNumber;
        this._presentationSector = presentationSector;
    }

    @Override
    public int getWidth() {
        return this._mdecPacket.getWidth();
    }

    @Override
    public int getHeight() {
        return this._mdecPacket.getHeight();
    }

    @Override
    @Nonnull
    public MdecInputStream getCustomFrameMdecStream() {
        return this._vlc.makeFrameBitStreamUncompressor(this._mdecPacket);
    }

    @Override
    @Nonnull
    public FrameNumber getFrame() {
        return this._frameNumber;
    }

    @Override
    public int getStartSector() {
        return this._sectors.iStartSector;
    }

    @Override
    public int getEndSector() {
        return this._sectors.iEndSector;
    }

    @Override
    @Nonnull
    public Fraction getPresentationSector() {
        return this._presentationSector;
    }

    @Override
    public int getDemuxSize() {
        return this._mdecPacket.getBitstream().length;
    }

    @Override
    @Nonnull
    public byte[] copyDemuxData() {
        return Arrays.copyOfRange(this._mdecPacket.getBitstream(), 0, this.getDemuxSize());
    }

    @Override
    public void printSectors(PrintStream ps) {
    }

    @Override
    public void writeToSectors(SectorBasedFrameAnalysis existingFrame, BitStreamAnalysis newFrame, CdFileSectorReader cd, ILocalizedLogger log) {
        throw new UnsupportedOperationException("No support for replacing EA video frames");
    }
}

