/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.dredd.DemuxedDreddFrame;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;

public class SectorDreddVideo
extends IdentifiedSector
implements DemuxedData.Piece,
SectorBasedFrameReplace.IReplaceableVideoSector {
    private int _iChunk;
    private int _iHeaderSize;
    @CheckForNull
    DemuxedDreddFrame _dreddFrame;

    @Override
    public int getVideoSectorHeaderSize() {
        return this._iHeaderSize;
    }

    public SectorDreddVideo(@Nonnull CdSector cdSector, int iChunk, int iHeaderSize) {
        super(cdSector);
        this._iChunk = iChunk;
        this._iHeaderSize = iHeaderSize;
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "Dredd";
    }

    public int getChunkNumber() {
        return this._iChunk;
    }

    public int getChunksInFrame() {
        if (this._dreddFrame == null) {
            throw new IllegalStateException();
        }
        return this._dreddFrame.getSectorCount();
    }

    @Override
    public final int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public final byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
    }

    @Override
    public final void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("%s %s chunk %d", this.getTypeName(), this.cdToString(), this.getChunkNumber()));
        if (this._dreddFrame != null) {
            sb.append(" frame ").append(this._dreddFrame);
        }
        if (this._iHeaderSize != 4) {
            sb.append(" + Unknown data");
        }
        return sb.toString();
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
    }
}

