/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.dredd.DreddDemuxer;
import jpsxdec.modules.dredd.SectorDreddVideo;
import jpsxdec.util.IOIterator;

public class SectorClaimToDreddFrame
implements SectorClaimSystem.SectorClaimer {
    @CheckForNull
    private ClaimedSectorCollector _claimedSectors;
    @CheckForNull
    private DreddDemuxer _nextDemuxer;

    @Override
    public void sectorRead(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt, @Nonnull ILocalizedLogger log) throws IOException, LoggedFailure {
        SectorDreddVideo dreddSector = this.dreddSectorLookAheadCheck(cs, peekIt);
    }

    @CheckForNull
    private SectorDreddVideo dreddSectorLookAheadCheck(@Nonnull SectorClaimSystem.ClaimableSector cs, @Nonnull IOIterator<SectorClaimSystem.ClaimableSector> peekIt) throws IOException, LoggedFailure {
        DreddDemuxer demuxer;
        if (cs.isClaimed()) {
            return null;
        }
        if (this._claimedSectors != null) {
            SectorDreddVideo dreddSector = this._claimedSectors.claimSectorIfDredd(cs);
            if (this._claimedSectors.allClaimed()) {
                this._claimedSectors = null;
            }
            return dreddSector;
        }
        if (this._nextDemuxer != null) {
            demuxer = this._nextDemuxer;
            this._nextDemuxer = null;
            if (!demuxer.matchesFirstSector(cs.getSector())) {
                throw new RuntimeException("CD sector does not match first Dredd sector");
            }
        } else {
            demuxer = DreddDemuxer.first(cs.getSector());
            if (demuxer == null) {
                return null;
            }
        }
        for (int iSectors = 0; peekIt.hasNext() && iSectors < 15; ++iSectors) {
            boolean blnTryToFinishTheFrame;
            SectorClaimSystem.ClaimableSector next = peekIt.next();
            if (next.isClaimed()) continue;
            this._nextDemuxer = DreddDemuxer.first(next.getSector());
            if (this._nextDemuxer != null || (blnTryToFinishTheFrame = demuxer.addSector(next.getSector()))) break;
        }
        List<SectorDreddVideo> frameSectors = demuxer.tryToFinishFrame();
        SectorDreddVideo dreddSector = null;
        if (frameSectors != null) {
            dreddSector = frameSectors.get(0);
            cs.claim(dreddSector);
            this._claimedSectors = new ClaimedSectorCollector(frameSectors);
        }
        return dreddSector;
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
        if (this._claimedSectors != null) {
            throw new RuntimeException("Created Dredd frame still remains at end of sectors");
        }
    }

    public void feedSector(@Nonnull IIdentifiedSector idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
    }

    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
    }

    private static class ClaimedSectorCollector {
        private final Map<Integer, SectorDreddVideo> _frameSectors = new TreeMap<Integer, SectorDreddVideo>();
        private final int _iMaxFrameSectorIndex;

        public ClaimedSectorCollector(@Nonnull List<SectorDreddVideo> frameSectors) {
            int iMaxFrameSectorIndex = frameSectors.get(0).getCdSector().getSectorIndexFromStart();
            for (int i = 1; i < frameSectors.size(); ++i) {
                SectorDreddVideo sector = frameSectors.get(i);
                this._frameSectors.put(sector.getCdSector().getSectorIndexFromStart(), sector);
                if (sector.getCdSector().getSectorIndexFromStart() <= iMaxFrameSectorIndex) continue;
                iMaxFrameSectorIndex = sector.getCdSector().getSectorIndexFromStart();
            }
            this._iMaxFrameSectorIndex = iMaxFrameSectorIndex;
        }

        public boolean allClaimed() {
            return this._frameSectors.isEmpty();
        }

        @CheckForNull
        public SectorDreddVideo claimSectorIfDredd(@Nonnull SectorClaimSystem.ClaimableSector cs) {
            if (this.allClaimed()) {
                throw new RuntimeException("_claimedSectors != null but all sectors are claimed");
            }
            if (cs.getSector().getSectorIndexFromStart() > this._iMaxFrameSectorIndex) {
                throw new RuntimeException("My Dredd logic bad, sector beyond claimed sectors");
            }
            SectorDreddVideo dreddSector = this._frameSectors.remove(cs.getSector().getSectorIndexFromStart());
            if (dreddSector != null) {
                cs.claim(dreddSector);
            }
            return dreddSector;
        }
    }
}

