/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.dredd.DemuxedDreddFrame;
import jpsxdec.modules.dredd.SectorDreddVideo;

public class DreddSectorToDreddFrame
implements IdentifiedSectorListener<IIdentifiedSector> {
    @Nonnull
    private final SectorRange _sectorRange;
    @Nonnull
    private final Listener _listener;

    public DreddSectorToDreddFrame(@Nonnull SectorRange sectorRange, @Nonnull Listener listener) {
        this._sectorRange = sectorRange;
        this._listener = listener;
    }

    @Override
    public Class<IIdentifiedSector> getListeningFor() {
        return IIdentifiedSector.class;
    }

    @Override
    public void feedSector(IIdentifiedSector idSector, ILocalizedLogger log) throws LoggedFailure {
        CdSectorXaSubHeader sh;
        SectorDreddVideo dreddSector = idSector instanceof SectorDreddVideo ? (SectorDreddVideo)idSector : null;
        if (dreddSector != null && dreddSector._dreddFrame != null && this._sectorRange.sectorIsInRange(idSector.getSectorNumber())) {
            this._listener.frameComplete(dreddSector._dreddFrame, log);
        }
        if ((sh = idSector.getCdSector().getSubHeader()) != null && sh.getSubMode().mask(128) != 0) {
            this._listener.videoBreak(log);
        }
    }

    @Override
    public void endOfFeedSectors(ILocalizedLogger log) throws LoggedFailure {
        this._listener.endOfSectors(log);
    }

    public static interface Listener {
        public void frameComplete(@Nonnull DemuxedDreddFrame var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void videoBreak(@Nonnull ILocalizedLogger var1);

        public void endOfSectors(@Nonnull ILocalizedLogger var1);
    }
}

