/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.modules.dredd.DemuxedDreddFrame;
import jpsxdec.modules.dredd.SectorDreddVideo;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv3;
import jpsxdec.psxvideo.bitstreams.StrHeader;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.ExposedBAOS;

public class DreddDemuxer {
    private static final Logger LOG = Logger.getLogger(DreddDemuxer.class.getName());
    public static final int MIN_CHUNKS_PER_FRAME = 9;
    public static final int MAX_CHUNKS_PER_FRAME = 10;
    @Nonnull
    private final StrHeader _strHeader;
    @Nonnull
    private final ArrayList<SectorDreddVideo> _sectors = new ArrayList(10);
    public static final int FRAME_WIDTH = 320;
    public static final int FRAME_HEIGHT_A = 352;
    public static final int FRAME_HEIGHT_B = 240;

    @CheckForNull
    public static DreddDemuxer first(@Nonnull CdSector cdSector) {
        int iFirstHeaderSize;
        if (!DreddDemuxer.commonSectorCheck(cdSector)) {
            return null;
        }
        int iChunk = cdSector.readSInt32LE(0);
        if (iChunk != 0) {
            return null;
        }
        StrHeader strHeader = DreddDemuxer.hasBitstreamHeader(cdSector, 4);
        if (strHeader != null) {
            iFirstHeaderSize = 4;
        } else {
            strHeader = DreddDemuxer.hasBitstreamHeader(cdSector, 44);
            if (strHeader != null) {
                iFirstHeaderSize = 44;
            } else {
                return null;
            }
        }
        return new DreddDemuxer(strHeader, new SectorDreddVideo(cdSector, iChunk, iFirstHeaderSize));
    }

    public DreddDemuxer(@Nonnull StrHeader strHeader, @Nonnull SectorDreddVideo firstDreddFrameSector) {
        this._strHeader = strHeader;
        this._sectors.add(firstDreddFrameSector);
    }

    public boolean matchesFirstSector(@Nonnull CdSector sector) {
        return this._sectors.get(0).getCdSector() == sector;
    }

    public boolean addSector(@Nonnull CdSector cdSector) {
        if (!DreddDemuxer.commonSectorCheck(cdSector)) {
            return false;
        }
        int iChunk = cdSector.readSInt32LE(0);
        if (iChunk != this._sectors.size()) {
            return true;
        }
        this._sectors.add(new SectorDreddVideo(cdSector, iChunk, 4));
        return this._sectors.size() == 10;
    }

    @CheckForNull
    public List<SectorDreddVideo> tryToFinishFrame() {
        DemuxedDreddFrame frame;
        int iHeight;
        if (this._sectors.size() < 8) {
            return null;
        }
        ExposedBAOS baos = new ExposedBAOS();
        for (SectorDreddVideo sectorDreddVideo : this._sectors) {
            int iSize = sectorDreddVideo.getDemuxPieceSize();
            byte[] abBuff = new byte[iSize];
            sectorDreddVideo.copyDemuxPieceData(abBuff, 0);
            baos.write(abBuff);
        }
        byte[] abDemuxBuffer = baos.toByteArray();
        if (!DreddDemuxer.checkHeight(abDemuxBuffer, this._strHeader)) {
            LOG.log(Level.WARNING, "Possible Dredd frame failed bitstream check starting with sector {0}", this._sectors.get(0));
            return null;
        }
        if (this._sectors.size() == 9) {
            iHeight = 352;
        } else {
            if (this._sectors.size() != 10) {
                throw new RuntimeException("Dredd frame with " + this._sectors.size() + " sectors");
            }
            iHeight = 240;
        }
        this._sectors.get((int)(this._sectors.size() - 1))._dreddFrame = frame = new DemuxedDreddFrame(new DemuxedData<SectorDreddVideo>(this._sectors), iHeight);
        return this._sectors;
    }

    private static boolean commonSectorCheck(@Nonnull CdSector cdSector) {
        CdSectorXaSubHeader sh = cdSector.getSubHeader();
        if (sh == null) {
            return false;
        }
        if (sh.getFileNumber() != 1 || sh.getChannel() != 2) {
            return false;
        }
        return sh.getSubMode().mask(-129) == 8;
    }

    @CheckForNull
    private static StrHeader hasBitstreamHeader(@Nonnull CdSector cdSector, int iOfs) {
        if (cdSector.getCdUserDataSize() + iOfs < 8) {
            return null;
        }
        byte[] abHeader = new byte[8];
        cdSector.getCdUserDataCopy(iOfs, abHeader, 0, abHeader.length);
        BitStreamUncompressor_STRv2.StrV2Header v2 = new BitStreamUncompressor_STRv2.StrV2Header(abHeader, abHeader.length);
        if (v2.isValid()) {
            return v2;
        }
        BitStreamUncompressor_STRv3.StrV3Header v3 = new BitStreamUncompressor_STRv3.StrV3Header(abHeader, abHeader.length);
        if (v3.isValid()) {
            return v3;
        }
        return null;
    }

    private static boolean checkHeight(@Nonnull byte[] abFullFrame, @Nonnull StrHeader strHeader) {
        try {
            BitStreamUncompressor bsu = strHeader.makeNew(abFullFrame);
            bsu.skipMacroBlocks(320, 240);
            return true;
        }
        catch (MdecException.EndOfStream ex) {
            return false;
        }
        catch (MdecException.ReadCorruption ex) {
            return false;
        }
        catch (BinaryDataNotRecognized ex) {
            return false;
        }
    }

    public static enum AddResult {
        FRAME_COMPLETE,
        FRAME_DEAD;

    }
}

