/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.dredd.DemuxedDreddFrame;
import jpsxdec.modules.dredd.DreddSectorToDreddFrame;
import jpsxdec.modules.dredd.SectorDreddVideo;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatter;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfo;
import jpsxdec.modules.xa.DiscItemXaAudioStream;

public class DiscItemDreddVideoStream
extends DiscItemSectorBasedVideoStream {
    private static final Logger LOG = Logger.getLogger(DiscItemDreddVideoStream.class.getName());
    public static final String TYPE_ID = "Dredd";
    private static final int AUDIO_SPLIT_THRESHOLD = 32;

    public DiscItemDreddVideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format indexSectorFrameNumberFormat, @Nonnull SectorBasedVideoInfo strVidInfo) {
        super(cd, iStartSector, iEndSector, dim, indexSectorFrameNumberFormat, strVidInfo);
    }

    public DiscItemDreddVideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return true;
    }

    @Override
    public int getParentRating(@Nonnull DiscItem child) {
        if (!(child instanceof DiscItemXaAudioStream)) {
            return 0;
        }
        int iOverlapPercent = child.getOverlap(this) * 100 / child.getSectorLength();
        if (iOverlapPercent > 0) {
            iOverlapPercent += 100;
        }
        return iOverlapPercent;
    }

    @Override
    public int findAudioSplitPoint(@Nonnull DiscItemXaAudioStream audio) {
        int iStartSector = this.getStartSector();
        if (audio.getStartSector() < iStartSector - 32 && audio.getEndSector() >= iStartSector) {
            return iStartSector - 2;
        }
        return -1;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        return this._indexSectorFrameNumberFormat.getStartFrame();
    }

    @Override
    public FrameNumber getEndFrame() {
        return this._indexSectorFrameNumberFormat.getEndFrame();
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Sector);
    }

    @Override
    public void fpsDump(@Nonnull PrintStream ps) throws CdFileSectorReader.CdReadException {
        SectorClaimSystem it = this.createClaimSystem();
        int iFrameIndex = 0;
        int iLastChunk = -1;
        int iSector = 0;
        while (it.hasNext()) {
            IIdentifiedSector isect = it.next(DebugLogger.Log);
            if (isect instanceof SectorDreddVideo) {
                SectorDreddVideo vidSect = (SectorDreddVideo)isect;
                ps.println(String.format("%-5d %-4d %d/%d", iSector, iFrameIndex, vidSect.getChunkNumber(), vidSect.getChunksInFrame()));
                if (vidSect.getChunkNumber() < iLastChunk) {
                    ++iFrameIndex;
                }
                iLastChunk = vidSect.getChunkNumber();
            } else {
                ps.println(String.format("%-5d X", iSector));
            }
            ++iSector;
        }
    }

    @Override
    @Nonnull
    public ISectorClaimToDemuxedFrame makeDemuxer() {
        return new Demuxer(this._indexSectorFrameNumberFormat.makeFormatter(), this.makeSectorRange());
    }

    public static class Demuxer
    implements ISectorClaimToDemuxedFrame,
    DreddSectorToDreddFrame.Listener {
        @Nonnull
        private final IFrameNumberFormatter _indexSectorFrameNumberFormatter;
        @CheckForNull
        private IDemuxedFrame.Listener _listener;
        @Nonnull
        private final SectorRange _sectorRange;

        private Demuxer(@Nonnull IFrameNumberFormatter indexSectorFrameNumberFormatter, @Nonnull SectorRange sectorRange) {
            this._indexSectorFrameNumberFormatter = indexSectorFrameNumberFormatter;
            this._sectorRange = sectorRange;
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            DreddSectorToDreddFrame s2f = new DreddSectorToDreddFrame(this._sectorRange, this);
            scs.addIdListener(s2f);
        }

        @Override
        public void setFrameListener(@Nonnull IDemuxedFrame.Listener listener) {
            this._listener = listener;
        }

        @Override
        public void frameComplete(@Nonnull DemuxedDreddFrame frame, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            FrameNumber fn = this._indexSectorFrameNumberFormatter.next(frame.getStartSector(), log);
            frame.setFrame(fn);
            if (this._listener != null) {
                this._listener.frameComplete(frame);
            }
        }

        @Override
        public void videoBreak(@Nonnull ILocalizedLogger log) {
            LOG.info("Dredd video break while saving");
        }

        @Override
        public void endOfSectors(@Nonnull ILocalizedLogger log) {
        }
    }
}

