/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.dredd.DemuxedDreddFrame;
import jpsxdec.modules.dredd.DiscItemDreddVideoStream;
import jpsxdec.modules.dredd.DreddSectorToDreddFrame;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DiscIndexerSectorBasedVideo;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfoBuilder;

public class DiscIndexerDredd
extends DiscIndexerSectorBasedVideo.SubIndexer
implements DreddSectorToDreddFrame.Listener {
    @CheckForNull
    private VidBuilder _videoBuilder;

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        DreddSectorToDreddFrame s2f = new DreddSectorToDreddFrame(SectorRange.ALL, this);
        scs.addIdListener(s2f);
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("Dredd".equals(fields.getType())) {
            return new DiscItemDreddVideoStream(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void frameComplete(@Nonnull DemuxedDreddFrame frame, @Nonnull ILocalizedLogger log) {
        if (this._videoBuilder != null && !this._videoBuilder.addFrame(frame)) {
            this.videoBreak(log);
        }
        if (this._videoBuilder == null) {
            this._videoBuilder = new VidBuilder(frame);
        }
    }

    @Override
    public void videoBreak(ILocalizedLogger log) {
        if (this._videoBuilder == null) {
            return;
        }
        DiscItemDreddVideoStream video = this._videoBuilder.endOfMovie(this.getCd());
        this.addVideo(video);
        this._videoBuilder = null;
    }

    @Override
    public void endOfSectors(ILocalizedLogger log) {
        this.videoBreak(log);
    }

    private static class VidBuilder {
        @Nonnull
        private final IndexSectorFrameNumber.Format.Builder _indexSectorFrameNumberBuilder;
        @Nonnull
        private final SectorBasedVideoInfoBuilder _strInfoBuilder;

        public VidBuilder(@Nonnull DemuxedDreddFrame firstFrame) {
            this._strInfoBuilder = new SectorBasedVideoInfoBuilder(firstFrame.getWidth(), firstFrame.getHeight(), firstFrame.getStartSector(), firstFrame.getEndSector());
            this._indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(firstFrame.getStartSector());
        }

        public boolean addFrame(@Nonnull DemuxedDreddFrame frame) {
            if (frame.getWidth() != this._strInfoBuilder.getWidth() || frame.getHeight() != this._strInfoBuilder.getHeight() || frame.getStartSector() > this._strInfoBuilder.getEndSector() + 100) {
                return false;
            }
            this._strInfoBuilder.next(frame.getStartSector(), frame.getEndSector());
            this._indexSectorFrameNumberBuilder.addFrameStartSector(frame.getStartSector());
            return true;
        }

        @Nonnull
        public DiscItemDreddVideoStream endOfMovie(@Nonnull CdFileSectorReader cd) {
            return new DiscItemDreddVideoStream(cd, this._strInfoBuilder.getStartSector(), this._strInfoBuilder.getEndSector(), this._strInfoBuilder.makeDims(), this._indexSectorFrameNumberBuilder.makeFormat(), this._strInfoBuilder.makeStrVidInfo());
        }
    }
}

