/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.dredd;

import java.io.PrintStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.dredd.SectorDreddVideo;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Fraction;

public class DemuxedDreddFrame
implements IDemuxedFrame {
    public static final int FRAME_WIDTH = 320;
    public static final int FRAME_HEIGHT_A = 352;
    public static final int FRAME_HEIGHT_B = 240;
    @Nonnull
    private final DemuxedData<SectorDreddVideo> _demux;
    private final int _iHeight;
    @CheckForNull
    private FrameNumber _frame;

    public DemuxedDreddFrame(@Nonnull DemuxedData<SectorDreddVideo> demux, int iHeight) {
        this._demux = demux;
        this._iHeight = iHeight;
    }

    @Override
    @CheckForNull
    public MdecInputStream getCustomFrameMdecStream() {
        return null;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getStartSector() {
        return this._demux.getStartSector();
    }

    @Override
    public int getEndSector() {
        return this._demux.getEndSector();
    }

    @Override
    public int getWidth() {
        return 320;
    }

    @Override
    @Nonnull
    public Fraction getPresentationSector() {
        return new Fraction(this.getEndSector());
    }

    @Override
    @Nonnull
    public FrameNumber getFrame() {
        if (this._frame == null) {
            throw new IllegalStateException();
        }
        return this._frame;
    }

    void setFrame(@Nonnull FrameNumber frame) {
        this._frame = frame;
    }

    @Override
    public int getDemuxSize() {
        return this._demux.getDemuxSize();
    }

    public int getSectorCount() {
        return this._demux.getPieceCount();
    }

    @Override
    @Nonnull
    public byte[] copyDemuxData() {
        return this._demux.copyDemuxData();
    }

    @Override
    public void printSectors(@Nonnull PrintStream ps) {
        for (SectorDreddVideo sdv : this._demux) {
            ps.println(sdv);
        }
    }

    @Override
    public void writeToSectors(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        SectorBasedFrameReplace.writeToSectors(existingFrame, newFrame, cd, log, this._demux);
    }

    public String toString() {
        return String.format("Dredd %dx%d sectors %d-%d count %d", this.getWidth(), this.getHeight(), this.getStartSector(), this.getEndSector(), this._demux.getPieceCount());
    }
}

