/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.util.Misc;

public class SectorCrusader
extends IdentifiedSector {
    private static final long MAGIC = 2864434397L;
    public static final int HEADER_SIZE = 8;
    private static final int MAX_CRUSADER_SECTOR = 15524;
    public static final int CRUSADER_IDENTIFIED_USER_DATA_SIZE = 2040;
    private int _iCrusaderSectorNumber;

    public SectorCrusader(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        long lngMagic = cdSector.readUInt32BE(0);
        if (lngMagic != 2864434397L) {
            return;
        }
        this._iCrusaderSectorNumber = cdSector.readSInt32BE(4);
        if (this._iCrusaderSectorNumber < 0 || this._iCrusaderSectorNumber > 15524) {
            return;
        }
        if (super.getCdSector().getCdUserDataSize() != 2048) {
            throw new RuntimeException("Crusader sector size isn't right");
        }
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "Crusader";
    }

    public int getCrusaderSectorNumber() {
        return this._iCrusaderSectorNumber;
    }

    public int getIdentifiedUserDataSize() {
        return 2040;
    }

    public byte readIdentifiedUserDataByte(int i) {
        if (i < 0 || i >= this.getIdentifiedUserDataSize()) {
            throw new IllegalArgumentException("Offset out of sector range " + i);
        }
        return super.getCdSector().readUserDataByte(8 + i);
    }

    public void copyIdentifiedUserData(int iSrcPos, @Nonnull byte[] abOut, int iOutPos, int iSize) {
        if (iSize < 0 || iSize > this.getIdentifiedUserDataSize()) {
            throw new IndexOutOfBoundsException();
        }
        super.getCdSector().getCdUserDataCopy(8 + iSrcPos, abOut, iOutPos, iSize);
    }

    @Override
    public String toString() {
        return this.getTypeName() + " " + this.getCdSector().toString() + " Sect:" + this._iCrusaderSectorNumber;
    }

    @Nonnull
    public String readMagic(int iIdentifiedUserDataOffset) {
        if (iIdentifiedUserDataOffset < 0 || iIdentifiedUserDataOffset > this.getIdentifiedUserDataSize() - 4) {
            throw new IndexOutOfBoundsException();
        }
        byte[] abMagic = new byte[4];
        this.getCdSector().getCdUserDataCopy(8 + iIdentifiedUserDataOffset, abMagic, 0, 4);
        return Misc.asciiToString(abMagic);
    }

    public int readSInt32BE(int iIdentifiedUserDataOffset) {
        if (iIdentifiedUserDataOffset < 0 || iIdentifiedUserDataOffset > this.getIdentifiedUserDataSize() - 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.getCdSector().readSInt32BE(8 + iIdentifiedUserDataOffset);
    }

    public int readSInt16BE(int iIdentifiedUserDataOffset) {
        if (iIdentifiedUserDataOffset < 0 || iIdentifiedUserDataOffset > this.getIdentifiedUserDataSize() - 2) {
            throw new IndexOutOfBoundsException();
        }
        return this.getCdSector().readSInt16BE(8 + iIdentifiedUserDataOffset);
    }
}

