/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.crusader.CrusaderPacketToFrameAndAudio;
import jpsxdec.modules.crusader.CrusaderSectorToCrusaderPacket;
import jpsxdec.modules.crusader.DemuxedCrusaderFrame;
import jpsxdec.modules.crusader.SectorCrusader;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.packetbased.DiscItemPacketBasedVideoStream;
import jpsxdec.modules.video.packetbased.SectorClaimToAudioAndFrame;
import jpsxdec.util.Fraction;

public class DiscItemCrusader
extends DiscItemPacketBasedVideoStream {
    public static final String TYPE_ID = "Crusader";
    private static final Fraction SECTORS_PER_FRAME = new Fraction(10);
    private static final int FPS = 15;
    @Nonnull
    private final HeaderFrameNumber.Format _headerFrameNumberFormat;
    private static final String INITIAL_PRES_SECTOR_KEY = "Initial presentation sector";
    private final int _iRelativeInitialFramePresentationSector;

    public DiscItemCrusader(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format sectorIndexFrameNumberFormat, @Nonnull HeaderFrameNumber.Format headerFrameNumberFormat, int iInitialPresentationSector, int iSoundUnitCount) {
        super(cd, iStartSector, iEndSector, dim, sectorIndexFrameNumberFormat, iSoundUnitCount);
        this._headerFrameNumberFormat = headerFrameNumberFormat;
        this._iRelativeInitialFramePresentationSector = iInitialPresentationSector;
    }

    public DiscItemCrusader(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._headerFrameNumberFormat = new HeaderFrameNumber.Format(fields);
        this._iRelativeInitialFramePresentationSector = fields.getInt(INITIAL_PRES_SECTOR_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._headerFrameNumberFormat.serialize(serial);
        serial.addNumber(INITIAL_PRES_SECTOR_KEY, this._iRelativeInitialFramePresentationSector);
        return serial;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return true;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        return this._headerFrameNumberFormat.getStartFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    public FrameNumber getEndFrame() {
        return this._headerFrameNumberFormat.getEndFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Header, FrameNumber.Type.Sector);
    }

    @Override
    protected double getPacketBasedFpsInterestingDescription() {
        return 15.0;
    }

    @Override
    @Nonnull
    public Fraction getSectorsPerFrame() {
        return SECTORS_PER_FRAME;
    }

    @Override
    public int getAudioSampleFramesPerSecond() {
        return 22050;
    }

    @Override
    public double getApproxDuration() {
        return (double)this.getFrameCount() / 15.0;
    }

    @Override
    @Nonnull
    public SectorClaimToAudioAndFrame makeAudioVideoDemuxer(double dblVolume) {
        return new Demuxer(dblVolume, this._headerFrameNumberFormat.makeFormatter(this._indexSectorFrameNumberFormat), this.makeSectorRange());
    }

    public class Demuxer
    extends SectorClaimToAudioAndFrame
    implements IdentifiedSectorListener<SectorCrusader>,
    CrusaderPacketToFrameAndAudio.FrameListener {
        private final double _dblVolume;
        @Nonnull
        private final IFrameNumberFormatterWithHeader _frameNumberFormatter;
        @Nonnull
        private final SectorRange _sectorRange;
        @Nonnull
        private final CrusaderPacketToFrameAndAudio _cp2a;
        @Nonnull
        private final CrusaderSectorToCrusaderPacket _cs2cp;
        @CheckForNull
        private IDemuxedFrame.Listener _listener;

        public Demuxer(@Nonnull double dblVolume, @Nonnull IFrameNumberFormatterWithHeader frameNumberFormatter, SectorRange sectorRange) {
            this._dblVolume = dblVolume;
            this._frameNumberFormatter = frameNumberFormatter;
            this._sectorRange = sectorRange;
            int iAbsoluteInitialFramePresentationSector = DiscItemCrusader.this._iRelativeInitialFramePresentationSector + DiscItemCrusader.this.getAbsolutePresentationStartSector();
            this._cp2a = new CrusaderPacketToFrameAndAudio(dblVolume, iAbsoluteInitialFramePresentationSector, this);
            this._cs2cp = new CrusaderSectorToCrusaderPacket(this._cp2a);
        }

        @Override
        public void setFrameListener(@CheckForNull IDemuxedFrame.Listener listener) {
            this._listener = listener;
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            scs.addIdListener(this);
        }

        @Override
        public Class<SectorCrusader> getListeningFor() {
            return SectorCrusader.class;
        }

        @Override
        public void feedSector(SectorCrusader idSector, ILocalizedLogger log) throws LoggedFailure {
            if (this._sectorRange.sectorIsInRange(idSector.getSectorNumber())) {
                this._cs2cp.sectorRead(idSector, log);
            }
        }

        @Override
        public void endOfFeedSectors(ILocalizedLogger log) throws LoggedFailure {
            this._cs2cp.endVideo(log);
        }

        @Override
        public void frameComplete(@Nonnull DemuxedCrusaderFrame frame, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            frame.setFrame(this._frameNumberFormatter.next(frame.getStartSector(), frame.getHeaderFrameNumber(), log));
            if (this._listener != null) {
                this._listener.frameComplete(frame);
            }
        }

        @Override
        public void videoEnd(@Nonnull ILocalizedLogger log, int iStartSector, int iEndSector) {
        }

        @Override
        public void setAudioListener(@Nonnull DecodedAudioPacket.Listener listener) {
            this._cp2a.setAudioListener(listener);
        }

        @Override
        @Nonnull
        public AudioFormat getOutputFormat() {
            return CrusaderPacketToFrameAndAudio.CRUSADER_AUDIO_FORMAT;
        }

        @Override
        public double getVolume() {
            return this._dblVolume;
        }

        @Override
        public int getAbsolutePresentationStartSector() {
            return DiscItemCrusader.this.getAbsolutePresentationStartSector();
        }

        @Override
        public int getStartSector() {
            return DiscItemCrusader.this.getStartSector();
        }

        @Override
        public int getEndSector() {
            return DiscItemCrusader.this.getEndSector();
        }

        @Override
        public int getSampleFramesPerSecond() {
            return 22050;
        }

        @Override
        public int getDiscSpeed() {
            return 2;
        }
    }
}

